/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.inferrer;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.DoubleLiteral;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.FloatLiteral;
import com.yakindu.base.expressions.expressions.HexLiteral;
import com.yakindu.base.expressions.expressions.InitializationExpression;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.ReturnExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.stext.inferrer.STextTypeInferrer;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JavaTypeSystemInferrer
extends STextTypeInferrer {
    @Inject
    @Extension
    private ITypeSystem _iTypeSystem;

    public ITypeSystemInferrer.InferenceResult doInfer(IntLiteral literal) {
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(StringLiteral literal) {
        return this.getResultFor("string");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(HexLiteral literal) {
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(DoubleLiteral literal) {
        return this.getResultFor("double");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FloatLiteral literal) {
        return this.getResultFor("float");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BoolLiteral literal) {
        return this.getResultFor("boolean");
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(IntLiteral lit, Expression exp) {
        return this.getResultFor("any");
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(IntLiteral e, Argument argument) {
        return this.assertedIntegerType(this.inferByContext((EObject)argument, argument.eContainer()), "Argument");
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(IntLiteral e, EventRaisingExpression context) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        EObject event = this.utils.featureOrReference(context.getEvent());
        if (event instanceof Event) {
            return this.assertedIntegerType(ITypeSystemInferrer.InferenceResult.from((Type)((Event)event).getType()), "Event payload");
        }
        _xblockexpression = this.getResultFor("any");
        return _xblockexpression;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(IntLiteral e, AssignmentExpression context) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        EObject variable = this.utils.featureOrReference(context.getVarRef());
        if (variable != null && variable instanceof Property) {
            return this.assertedIntegerType(this.inferTypeDispatch(variable), "Assignment target");
        }
        _xblockexpression = this.getResultFor("any");
        return _xblockexpression;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(IntLiteral e, Property context) {
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        TypeSpecifier _typeSpecifier = context.getTypeSpecifier();
        boolean _tripleNotEquals = _typeSpecifier != null;
        _xifexpression = _tripleNotEquals ? this.inferTypeDispatch((EObject)context) : this.getResultFor("integer");
        return _xifexpression;
    }

    protected ITypeSystemInferrer.InferenceResult assertedIntegerType(ITypeSystemInferrer.InferenceResult it, String subject) {
        if (it != null) {
            boolean _not;
            boolean _isInteger = this._iTypeSystem.isInteger(it.getType());
            boolean bl = _not = !_isInteger;
            if (_not) {
                this.assertNotType(it, subject + " is no integer type.", new ITypeSystemInferrer.InferenceResult[0]);
                return this.getResultFor("any");
            }
            return it;
        }
        return this.getResultFor("any");
    }

    public void assertAssignable(ITypeSystemInferrer.InferenceResult varResult, ITypeSystemInferrer.InferenceResult valueResult, String msg) {
        Type integerType = this._iTypeSystem.getType("integer");
        boolean _isSame = this._iTypeSystem.isSame(valueResult.getType(), integerType);
        if (_isSame) {
            boolean _isSuperType = this._iTypeSystem.isSuperType(varResult.getType(), integerType);
            if (_isSuperType) {
                return;
            }
            boolean _isConvertableTo = this._iTypeSystem.isConvertableTo(varResult.getType(), integerType);
            if (_isConvertableTo) {
                return;
            }
        }
        super.assertAssignable(varResult, valueResult, msg);
    }

    @XbaseGenerated
    public ITypeSystemInferrer.InferenceResult inferByContext(EObject e, EObject context) {
        if (e instanceof InitializationExpression && context instanceof Property) {
            return this._inferByContext((InitializationExpression)e, (Property)context);
        }
        if (e instanceof IntLiteral && context instanceof Property) {
            return this._inferByContext((IntLiteral)e, (Property)context);
        }
        if (e instanceof InitializationExpression && context instanceof AssignmentExpression) {
            return this._inferByContext((InitializationExpression)e, (AssignmentExpression)context);
        }
        if (e instanceof InitializationExpression && context instanceof EventRaisingExpression) {
            return this._inferByContext((InitializationExpression)e, (EventRaisingExpression)context);
        }
        if (e instanceof InitializationExpression && context instanceof ReturnExpression) {
            return this._inferByContext((InitializationExpression)e, (ReturnExpression)context);
        }
        if (e instanceof IntLiteral && context instanceof AssignmentExpression) {
            return this._inferByContext((IntLiteral)e, (AssignmentExpression)context);
        }
        if (e instanceof IntLiteral && context instanceof EventRaisingExpression) {
            return this._inferByContext((IntLiteral)e, (EventRaisingExpression)context);
        }
        if (e instanceof InitializationExpression && context instanceof Argument) {
            return this._inferByContext((InitializationExpression)e, (Argument)context);
        }
        if (e instanceof InitializationExpression && context instanceof Expression) {
            return this._inferByContext((InitializationExpression)e, (Expression)context);
        }
        if (e instanceof IntLiteral && context instanceof Argument) {
            return this._inferByContext((IntLiteral)e, (Argument)context);
        }
        if (e instanceof IntLiteral && context instanceof Expression) {
            return this._inferByContext((IntLiteral)e, (Expression)context);
        }
        if (e instanceof Argument && context instanceof ArgumentExpression) {
            return this._inferByContext((Argument)e, (ArgumentExpression)context);
        }
        if (e instanceof Argument && context instanceof InitializationExpression) {
            return this._inferByContext((Argument)e, (InitializationExpression)context);
        }
        if (e != null && context != null) {
            return this._inferByContext(e, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, context).toString());
    }
}

