/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.xtext.utils.jface.viewers.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActiveEditorTracker
implements IPageListener,
IPartListener,
IStartup,
IWindowListener {
    private static final String SINGLETON_MSG = "This class is a singleton and may only be instantiated once!";
    private IWorkbenchWindow workbenchWindow;
    private Map<String, IEditorPart> activeEditors = new HashMap<String, IEditorPart>();
    private String lastActiveEditorId;
    private IWorkbenchPage activePage;
    private static ActiveEditorTracker INSTANCE;

    public ActiveEditorTracker() {
        if (INSTANCE != null) {
            throw new IllegalStateException(SINGLETON_MSG);
        }
        INSTANCE = this;
    }

    public void earlyStartup() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    public static IEditorPart getLastActiveEditor() {
        if (INSTANCE == null) {
            if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
            return null;
        }
        return INSTANCE.getLastActiveEditorInternal();
    }

    public static IEditorPart getLastEditor(String editorId) {
        if (INSTANCE == null) {
            IWorkbenchPage page;
            IWorkbenchWindow window;
            if (PlatformUI.getWorkbench() != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    if (ref.getId().equals(editorId)) {
                        return ref.getEditor(false);
                    }
                    ++n2;
                }
            }
            return null;
        }
        return INSTANCE.getEditorById(editorId);
    }

    public static ResourceSet getLastActiveEditorResourceSet() {
        IEditorPart editor = ActiveEditorTracker.getLastActiveEditor();
        if (editor == null) {
            return null;
        }
        EditingDomain domain = null;
        if (editor instanceof IEditingDomainProvider) {
            domain = ((IEditingDomainProvider)editor).getEditingDomain();
        } else if (editor.getAdapter(IEditingDomainProvider.class) != null) {
            domain = ((IEditingDomainProvider)editor.getAdapter(IEditingDomainProvider.class)).getEditingDomain();
        } else if (editor.getAdapter(EditingDomain.class) != null) {
            domain = (EditingDomain)editor.getAdapter(EditingDomain.class);
        }
        if (domain == null) {
            return null;
        }
        return domain.getResourceSet();
    }

    public static IProject getLastActiveEditorProject() {
        URI uri;
        IEditorPart editor = ActiveEditorTracker.getLastActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)editorInput;
            return input.getFile().getProject();
        }
        if (editorInput instanceof URIEditorInput && (uri = ((URIEditorInput)editorInput).getURI()).isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            return ResourcesPlugin.getWorkspace().getRoot().findMember(platformString).getProject();
        }
        return null;
    }

    public void pageActivated(IWorkbenchPage page) {
        this.activePage = page;
    }

    public void pageClosed(IWorkbenchPage page) {
        if (page == this.activePage) {
            this.activePage = null;
        }
        this.lastActiveEditorId = null;
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.setActiveEditor((IEditorPart)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.setActiveEditor((IEditorPart)part);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            String id = null;
            for (Map.Entry<String, IEditorPart> entry : this.activeEditors.entrySet()) {
                if (!entry.getValue().equals(part)) continue;
                id = entry.getKey();
                break;
            }
            if (id != null) {
                this.activeEditors.remove(id);
                if (id.equals(this.lastActiveEditorId)) {
                    this.lastActiveEditorId = null;
                }
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        boolean cfr_ignored_0 = part instanceof IEditorPart;
    }

    private IEditorPart getLastActiveEditorInternal() {
        IEditorPart editor;
        if (this.activePage == null) {
            this.initialize(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            if (this.activePage == null) {
                return null;
            }
        }
        boolean updated = false;
        if (this.lastActiveEditorId == null) {
            editor = this.activePage.getActiveEditor();
            if (editor != null) {
                this.setActiveEditor(editor);
            }
            updated = true;
        }
        if ((editor = this.getEditorById(this.lastActiveEditorId)) == null && !updated && (editor = this.activePage.getActiveEditor()) != null) {
            this.setActiveEditor(editor);
        }
        return editor;
    }

    private IEditorPart getEditorById(String editorId) {
        if (this.activePage == null || editorId == null) {
            return null;
        }
        IEditorPart editor = this.activeEditors.get(editorId);
        String id = this.checkEditorAndGetId(editor);
        if (id != null && id.equals(editorId)) {
            return editor;
        }
        return null;
    }

    private String checkEditorAndGetId(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = this.activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if (editor.equals(ref.getEditor(false))) {
                return ref.getId();
            }
            ++n2;
        }
        return null;
    }

    public IWorkbenchPage getActivePage() {
        return this.activePage;
    }

    private void setActiveEditor(IEditorPart part) {
        if (part == null) {
            this.lastActiveEditorId = null;
            return;
        }
        IWorkbenchPartReference reference = this.activePage.getReference((IWorkbenchPart)part);
        if (reference == null) {
            throw new IllegalStateException("Impossible?!");
        }
        this.lastActiveEditorId = reference.getId();
        this.activeEditors.put(this.lastActiveEditorId, part);
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.setActiveEditor((IEditorPart)part);
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow.removePageListener((IPageListener)this);
        this.workbenchWindow.getPartService().removePartListener((IPartListener)this);
        this.workbenchWindow = null;
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.initialize(window);
    }

    protected void initialize(IWorkbenchWindow window) {
        if (this.workbenchWindow != null) {
            this.workbenchWindow.equals(window);
        }
        this.workbenchWindow = window;
        if (window == null) {
            return;
        }
        this.activePage = window.getActivePage();
        IEditorPart editor = this.activePage.getActiveEditor();
        if (editor != null) {
            this.lastActiveEditorId = this.checkEditorAndGetId(editor);
            this.activeEditors.put(this.lastActiveEditorId, editor);
        }
        window.addPageListener((IPageListener)this);
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.dispose();
    }

    public void windowOpened(IWorkbenchWindow window) {
    }
}

