/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.core.filter.sct;

import com.google.common.collect.Sets;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.search.core.SearchEntry;
import com.yakindu.sct.search.core.filter.ModelFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class CrossReferenceFilter
extends ModelFilter {
    protected Map<EObject, Set<EObject>> referenceMap = new HashMap<EObject, Set<EObject>>();
    protected Map<Resource, Set<EObject>> resourceToReferences = new HashMap<Resource, Set<EObject>>();
    protected Set<Resource> resources = new HashSet<Resource>();
    private EObject referencedElement;

    public CrossReferenceFilter(EObject referencedElement) {
        this.referencedElement = referencedElement;
        this.calculateReferences(referencedElement);
    }

    protected CrossReferenceFilter() {
    }

    private void addReference(EObject referencedElement, EObject reference) {
        if (this.referenceMap.containsKey(referencedElement)) {
            this.referenceMap.get(referencedElement).add(reference);
        } else {
            this.referenceMap.put(referencedElement, Sets.newHashSet((Object[])new EObject[]{reference}));
        }
    }

    @Override
    public List<SearchEntry> apply(EObject initValue, Object input) {
        ArrayList<SearchEntry> returnList = new ArrayList<SearchEntry>();
        boolean isSearchEntry = input instanceof SearchEntry;
        EObject object = isSearchEntry ? ((SearchEntry)input).getReference() : (EObject)input;
        Resource resource = object.eResource();
        if (resource == null) {
            return returnList;
        }
        if (this.resources.contains(resource) && this.resourceToReferences.containsKey(resource)) {
            Set<EObject> referencedElements = this.resourceToReferences.get(resource);
            for (EObject referencedElement : referencedElements) {
                if (!this.referenceMap.containsKey(referencedElement) || !this.referenceMap.get(referencedElement).contains(object)) continue;
                SearchEntry searchEntry = new SearchEntry(referencedElement);
                returnList.addAll(this.notifyChildren(initValue, searchEntry));
            }
        }
        return returnList;
    }

    protected void calculateReferences(EObject referencedElement) {
        this.resources.add(referencedElement.eResource());
        if (this.resourceToReferences.containsKey(referencedElement.eResource())) {
            this.resourceToReferences.get(referencedElement.eResource()).add(referencedElement);
        } else {
            this.resourceToReferences.put(referencedElement.eResource(), Sets.newHashSet((Object[])new EObject[]{referencedElement}));
        }
        this.addReference(referencedElement, referencedElement);
        if (referencedElement instanceof Literal) {
            return;
        }
        EObject container = referencedElement.eContainer();
        InterfaceScope scope = null;
        if (container instanceof InterfaceScope) {
            scope = (InterfaceScope)container;
        }
        TreeIterator contents = EcoreUtil.getRootContainer((EObject)referencedElement).eAllContents();
        while (contents.hasNext()) {
            EObject content = (EObject)contents.next();
            for (EObject crossRef : content.eCrossReferences()) {
                if (crossRef.eIsProxy()) {
                    crossRef = EcoreUtil.resolve((EObject)crossRef, (EObject)content);
                }
                if (!EcoreUtil.equals((EObject)crossRef, (EObject)referencedElement) || scope != null && crossRef.eContainer() != scope || content instanceof Transition && ((Transition)content).getTarget() == referencedElement) continue;
                Transition closeElement1 = (Transition)EcoreUtil2.getContainerOfType((EObject)content, Transition.class);
                Vertex closeElement2 = (Vertex)EcoreUtil2.getContainerOfType((EObject)content, Vertex.class);
                if (closeElement1 == null && closeElement2 == null) continue;
                if (closeElement1 == null) {
                    this.addReference(referencedElement, (EObject)closeElement2);
                    continue;
                }
                if (closeElement2 == null) {
                    this.addReference(referencedElement, (EObject)closeElement1);
                    continue;
                }
                if (EcoreUtil.isAncestor((EObject)closeElement1, (EObject)closeElement2)) {
                    this.addReference(referencedElement, (EObject)closeElement2);
                    continue;
                }
                this.addReference(referencedElement, (EObject)closeElement1);
            }
        }
    }

    @Override
    protected void doReset() {
        this.resources.clear();
        this.resourceToReferences.clear();
        this.referenceMap.clear();
        this.calculateReferences(this.referencedElement);
    }
}

