/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.validation;

import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.validation.BaseSCTUnitValidator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class ReturnStatementValidator
extends BaseSCTUnitValidator {
    @Check
    public void checkReturnStatementOnlyLastOrLastInIf(ReturnStatement statement) {
        List statements = (List)statement.eContainer().eGet(statement.eContainingFeature());
        if (statements.indexOf(statement) != statements.size() - 1) {
            this.error("The following code is not reachable", null);
        }
    }

    @Check
    public void checkReturnTypeMatchOperationType(ReturnStatement statement) {
        ITypeSystemInferrer ti = this.typeInferrer;
        ITypeSystem ts = this.getTypeSystem(statement);
        Type rsType = ti.infer((EObject)statement, (IValidationIssueAcceptor)this).getType();
        SCTUnitOperation containingOp = (SCTUnitOperation)EcoreUtil2.getContainerOfType((EObject)statement, SCTUnitOperation.class);
        ITypeSystemInferrer.InferenceResult operationType = ti.infer((EObject)containingOp, (IValidationIssueAcceptor)this);
        if (!ts.isSuperType(operationType.getType(), rsType)) {
            this.error(String.format("The return type '%s' does not match the type of the operation '%s'", rsType, operationType), statement, null);
        }
    }
}

