/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.generic.editor;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.sct.model.stext.stext.StatechartSpecification;
import com.yakindu.sct.model.stext.ui.contentassist.STextProposalProvider;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;

public abstract class LanguageDomainProposalProvider
extends STextProposalProvider {
    @Inject
    protected IResourceDescriptions descriptions;

    protected void _addSuppressions(List<Keyword> suppressKeywords, StatechartSpecification model, ContentAssistContext context) {
        Keyword prefix;
        if (context.getLastCompleteNode().getGrammarElement() instanceof Keyword && ":".equals((prefix = (Keyword)context.getLastCompleteNode().getGrammarElement()).getValue())) {
            suppressKeywords.addAll(this.getKeywords(this.grammarAccess.getExitEventAccess().getGroup().eContents()));
            suppressKeywords.addAll(this.getKeywords(this.grammarAccess.getEntryEventAccess().getGroup().eContents()));
        }
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
        if (element instanceof Type) {
            return this.computeStyledString((Type)element, qualifiedName, shortName);
        }
        if (element instanceof Operation) {
            return this.computeStyledString((Operation)element, qualifiedName, shortName);
        }
        if (element instanceof Property) {
            return this.computeStyledString((Property)element, qualifiedName, shortName);
        }
        return super.getStyledDisplayString(element, qualifiedName, shortName);
    }

    protected StyledString computeStyledString(Operation operation, String qualifiedName, String shortName) {
        String signature = this.getUserData((EObject)operation, this.getOperationSignatureUserDataKey());
        if (signature != null && !signature.isEmpty()) {
            StyledString firstPart = new StyledString(signature);
            StyledString secondPart = this.getPackageImportStyleString(EcoreUtil.getURI((EObject)operation));
            return firstPart.append(secondPart);
        }
        return super.getStyledDisplayString((EObject)operation, qualifiedName, shortName);
    }

    protected String getOperationSignatureUserDataKey() {
        return "operation_signature";
    }

    protected StyledString computeStyledString(Type type, String qualifiedName, String shortName) {
        String displayString = this.getDisplayString((EObject)type, qualifiedName, shortName);
        int i = displayString.lastIndexOf("-");
        if (i >= 0) {
            String simplePart = displayString.substring(0, i);
            String qualifiedPart = displayString.substring(i);
            return new StyledString(simplePart, this.getStyleForSimpleNamePart(type)).append(new StyledString(qualifiedPart, this.getStyleForQualifiedNamePart(type)));
        }
        return new StyledString(displayString, this.getStyleForSimpleNamePart(type));
    }

    protected StyledString computeStyledString(Property prop, String qualifiedName, String shortName) {
        String displayString = this.getDisplayString((EObject)prop, qualifiedName, shortName);
        if (prop == null || prop.eIsProxy()) {
            return new StyledString(shortName, null).append(this.getPackageImportStyleString(EcoreUtil.getURI((EObject)prop)));
        }
        return new StyledString(displayString, null);
    }

    protected StyledString.Styler getStyleForQualifiedNamePart(Type type) {
        return new STextProposalProvider.GreyoutStyler();
    }

    protected StyledString.Styler getStyleForSimpleNamePart(Type type) {
        if (this.isUnknownType(type)) {
            return new STextProposalProvider.StrikeThroughStyler();
        }
        return null;
    }

    protected boolean isUnknownType(Type type) {
        String isUnknowType = this.getUserData((EObject)type, "has_unknown_type");
        return Boolean.valueOf(isUnknowType);
    }

    protected String getUserData(EObject eobject, String userDataKey) {
        Iterable exportedObjectsByObject;
        URI uri = EcoreUtil.getURI((EObject)eobject).trimFragment();
        IResourceDescription resourceDescription = this.descriptions.getResourceDescription(uri);
        if (resourceDescription != null && Iterables.size((Iterable)(exportedObjectsByObject = this.descriptions.getResourceDescription(uri).getExportedObjectsByObject(eobject))) == 1) {
            IEObjectDescription next = (IEObjectDescription)exportedObjectsByObject.iterator().next();
            return next.getUserData(userDataKey);
        }
        return null;
    }
}

