/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.python.extensions;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions;
import com.yakindu.sctunit.generator.python.extensions.PythonExpressionExtensions;
import com.yakindu.sctunit.generator.python.extensions.UnittestMockingExtensions;
import com.yakindu.sctunit.sCTUnit.AssertionStatement;
import com.yakindu.sctunit.sCTUnit.ExpressionStatement;
import com.yakindu.sctunit.sCTUnit.IfStatement;
import com.yakindu.sctunit.sCTUnit.LoopStatement;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class PythonStatementExtensions
extends BaseStatementExtensions {
    @Inject
    @Extension
    private PythonExpressionExtensions _pythonExpressionExtensions;
    @Inject
    @Extension
    private UnittestMockingExtensions _unittestMockingExtensions;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;

    protected CharSequence _generate(ExpressionStatement stm) {
        if (stm.getExpression() instanceof PrimitiveValueExpression && this.contextNotAssignOrVarDef(stm)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("return ");
            CharSequence _code = this._pythonExpressionExtensions.code((EObject)stm.getExpression());
            _builder.append((Object)_code);
            return _builder;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        CharSequence _code_1 = this._pythonExpressionExtensions.code((EObject)stm.getExpression());
        _builder_1.append((Object)_code_1);
        return _builder_1;
    }

    protected CharSequence _generate(AssertionStatement stm) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("self.assertTrue(");
        CharSequence _code = this._pythonExpressionExtensions.code((EObject)stm.getExpression());
        _builder.append((Object)_code);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)stm.getErrorMsg());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(", '");
            String _errorMsg = stm.getErrorMsg();
            _builder.append(_errorMsg);
            _builder.append("'");
        }
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generate(IfStatement stm) {
        return this._pythonExpressionExtensions.code((EObject)stm);
    }

    protected CharSequence _generate(VariableDefinitionStatement stm) {
        boolean _tripleNotEquals;
        StringConcatenation _xifexpression = null;
        Expression _initialValue = stm.getDefinition().getInitialValue();
        boolean bl = _tripleNotEquals = _initialValue != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            String _identifier = this._naming.identifier((EObject)stm.getDefinition());
            _builder.append(_identifier);
            _builder.append(" = ");
            CharSequence _code = this._pythonExpressionExtensions.code((EObject)stm.getDefinition().getInitialValue());
            _builder.append((Object)_code);
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _identifier_1 = this._naming.identifier((EObject)stm.getDefinition());
            _builder_1.append(_identifier_1);
            _builder_1.append(" = None");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence _generate(LoopStatement stm) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while (");
        CharSequence _code = this._pythonExpressionExtensions.code((EObject)stm.getGuard());
        _builder.append((Object)_code);
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)stm.getBody().getCode());
        if (_isNullOrEmpty) {
            _builder.append("\t");
            _builder.append("pass");
            _builder.newLine();
        }
        EList _code_1 = stm.getBody().getCode();
        for (TestStatement statement : _code_1) {
            _builder.append("\t");
            CharSequence _generate = this.generate(statement);
            _builder.append((Object)_generate, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generate(ReturnStatement stm) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return ");
        Expression _returnValue = stm.getReturnValue();
        boolean bl = _tripleNotEquals = _returnValue != null;
        if (_tripleNotEquals) {
            CharSequence _code = this._pythonExpressionExtensions.code((EObject)stm.getReturnValue());
            _builder.append((Object)_code);
        }
        return _builder;
    }

    protected CharSequence _generate(VerifyCalledStatement it) {
        return this._unittestMockingExtensions.generateVerify(it);
    }

    protected CharSequence _generate(MockReturnStatement it) {
        return this._unittestMockingExtensions.generateMockReturn(it);
    }

    public CharSequence generateInitialValue(VariableDefinition it, Expression expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getType());
        _builder.append(_targetLanguageName);
        _builder.append(" = ");
        CharSequence _code = this._pythonExpressionExtensions.code((EObject)expr);
        _builder.append((Object)_code);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public long getCyclePeriod(SCTUnitClass it) {
        return this._statechartAnnotations.getCyclePeriod((EObject)it.getStatechart());
    }

    protected boolean isTypeString(Property it) {
        ITypeSystem _typeSystem = this.getTypeSystem((EObject)it);
        Type _type = it.getType();
        Type _originType = null;
        if (_type != null) {
            _originType = _type.getOriginType();
        }
        return _typeSystem.isSame(_originType, this.getTypeSystem((EObject)it).getType("string"));
    }

    @XbaseGenerated
    public CharSequence generate(TestStatement it) {
        if (it instanceof MockReturnStatement) {
            return this._generate((MockReturnStatement)it);
        }
        if (it instanceof VerifyCalledStatement) {
            return this._generate((VerifyCalledStatement)it);
        }
        if (it instanceof AssertionStatement) {
            return this._generate((AssertionStatement)it);
        }
        if (it instanceof ExpressionStatement) {
            return this._generate((ExpressionStatement)it);
        }
        if (it instanceof IfStatement) {
            return this._generate((IfStatement)it);
        }
        if (it instanceof LoopStatement) {
            return this._generate((LoopStatement)it);
        }
        if (it instanceof ReturnStatement) {
            return this._generate((ReturnStatement)it);
        }
        if (it instanceof VariableDefinitionStatement) {
            return this._generate((VariableDefinitionStatement)it);
        }
        if (it != null) {
            return this._generate(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

