/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.naming;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.sct.model.sgraph.naming.SGraphNameProvider;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

@Singleton
public class StextNameProvider
extends SGraphNameProvider {
    @Inject
    protected IQualifiedNameConverter nameConverter;

    public QualifiedName qualifiedName(Event ele) {
        return this.doComputeQualifiedName((NamedElement)ele);
    }

    public QualifiedName qualifiedName(Property ele) {
        return this.doComputeQualifiedName((NamedElement)ele);
    }

    public QualifiedName qualifiedName(Operation ele) {
        return this.doComputeQualifiedName((NamedElement)ele);
    }

    protected QualifiedName doComputeQualifiedName(NamedElement ele) {
        InterfaceScope scope;
        QualifiedName name = null;
        if (!Strings.isEmpty((String)ele.getName())) {
            name = this.nameConverter.toQualifiedName(ele.getName());
        }
        if ((scope = (InterfaceScope)EcoreUtil2.getContainerOfType((EObject)ele, InterfaceScope.class)) != null && !Strings.isEmpty((String)scope.getName())) {
            QualifiedName namespace = this.nameConverter.toQualifiedName(scope.getName());
            name = namespace.append(name);
        }
        return name;
    }

    public QualifiedName qualifiedName(InterfaceScope ele) {
        QualifiedName namespace;
        QualifiedName name = null;
        if (!Strings.isEmpty((String)ele.getName())) {
            name = this.nameConverter.toQualifiedName(ele.getName());
        }
        if ((namespace = this.getNamespace((EObject)ele)) != null && name != null) {
            name = namespace.append(name);
        }
        return name;
    }

    protected QualifiedName getNamespace(EObject child) {
        InterfaceScope interfaceScope;
        QualifiedName name = super.getNamespace(child);
        if (!(child instanceof InterfaceScope) && (interfaceScope = (InterfaceScope)EcoreUtil2.getContainerOfType((EObject)child, InterfaceScope.class)) != null && this.getFullyQualifiedName((EObject)interfaceScope) != null) {
            name = this.getFullyQualifiedName((EObject)interfaceScope);
        }
        return name;
    }
}

