/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.EventSpec;
import com.yakindu.base.expressions.expressions.ExpressionsPackage;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.Guard;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.ReactionEffect;
import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.expressions.expressions.RegularEventSpec;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.stext.AlwaysEvent;
import com.yakindu.sct.model.stext.stext.EntryEvent;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.ExitEvent;
import com.yakindu.sct.model.stext.stext.LocalReaction;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ReactionValidator
extends STextBaseValidator {
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject
    @Extension
    private STextExtensions _sTextExtensions;
    @Inject
    @Extension
    private IQualifiedNameProvider nameProvider;
    @Inject
    @Extension
    private StatechartUtil _statechartUtil;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    private static final String ENTRY_EXIT_TRIGGER_NOT_ALLOWED_MSG = "Entry and exit events are allowed as local reactions only.";
    public static final String ENTRY_EXIT_TRIGGER_NOT_ALLOWED_CODE = "EntryExitNotAllowed";
    public static final String TRIGGER_IS_NO_EVENT = "Trigger is no event.";
    public static final String FEATURE_CALL_HAS_NO_EFFECT = "FeatureCall has no effect.";
    public static final String REACTING_ON_SUBMACHINES_IN_EVENT = "Can not react on submachine's in event. Use an out event instead of: ";
    public static final String REACTING_ON_SUBMACHINES_IN_EVENT_CODE = "ReactingOnSubmachinesInEventCode";
    public static final String SELF_TRANSITION_INFINITE_LOOP = "Using %s trigger on a self-transition with enabled super steps may cause an infinite loop.";
    public static final String SELF_TRANSITION_INFINITE_LOOP_CODE = "SelfTransitionInfiniteLoop";

    @Check(value=CheckType.FAST)
    public void checkReactionTrigger(ReactionTrigger reactionTrigger) {
        EList _triggers = reactionTrigger.getTriggers();
        for (EventSpec eventSpec : _triggers) {
            if (reactionTrigger.eContainer() instanceof LocalReaction || !(eventSpec instanceof EntryEvent) && !(eventSpec instanceof ExitEvent)) continue;
            this.error(ENTRY_EXIT_TRIGGER_NOT_ALLOWED_MSG, (EStructuralFeature)ExpressionsPackage.Literals.REACTION_TRIGGER__TRIGGERS, -1, ENTRY_EXIT_TRIGGER_NOT_ALLOWED_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkReactionTriggerRegularEvent(ReactionTrigger reactionTrigger) {
        int i = 0;
        while (i < reactionTrigger.getTriggers().size()) {
            EObject element;
            EventSpec eventSpec = (EventSpec)reactionTrigger.getTriggers().get(i);
            if (eventSpec instanceof RegularEventSpec && (element = this._expressionExtensions.featureOrReference(((RegularEventSpec)eventSpec).getEvent())) != null && !(element instanceof Event)) {
                ICompositeNode triggerNode = NodeModelUtils.getNode((EObject)eventSpec);
                String elementName = NodeModelUtils.getTokenText((INode)triggerNode);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Trigger '");
                _builder.append(elementName);
                _builder.append("' is no event.");
                String _platformString = this.getContextElementURI().toPlatformString(true);
                String _plus = _platformString + "#";
                String _fragment = this.getContextElementURI().fragment();
                String _plus_1 = _plus + _fragment;
                this.error(_builder.toString(), (EObject)reactionTrigger, (EStructuralFeature)ExpressionsPackage.Literals.REACTION_TRIGGER__TRIGGERS, i, TRIGGER_IS_NO_EVENT, new String[]{_plus_1, elementName});
            }
            ++i;
        }
    }

    @Check(value=CheckType.FAST)
    public void checkReactionEffectActions(ReactionEffect effect) {
        EList _actions = effect.getActions();
        for (Expression exp : _actions) {
            if (exp instanceof AssignmentExpression || exp instanceof EventRaisingExpression || exp instanceof PostFixUnaryExpression) continue;
            if (exp instanceof FeatureCall) {
                this.checkFeatureCallEffect((FeatureCall)exp);
                continue;
            }
            if (exp instanceof ElementReferenceExpression) {
                this.checkElementReferenceEffect((ElementReferenceExpression)exp);
                continue;
            }
            this.error("Action has no effect.", (EStructuralFeature)ExpressionsPackage.Literals.REACTION_EFFECT__ACTIONS, effect.getActions().indexOf((Object)exp), FEATURE_CALL_HAS_NO_EFFECT, new String[0]);
        }
    }

    protected void checkElementReferenceEffect(ElementReferenceExpression refExp) {
        boolean _not;
        EObject _reference = refExp.getReference();
        boolean bl = _not = !(_reference instanceof Operation);
        if (_not) {
            EObject _reference_1 = refExp.getReference();
            if (_reference_1 instanceof Property) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Access to property '");
                QualifiedName _fullyQualifiedName = this.nameProvider.getFullyQualifiedName(refExp.getReference());
                _builder.append((Object)_fullyQualifiedName);
                _builder.append("' has no effect.");
                this.error(_builder.toString(), (EObject)refExp, (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1, FEATURE_CALL_HAS_NO_EFFECT, new String[0]);
            } else {
                EObject _reference_2 = refExp.getReference();
                if (_reference_2 instanceof Event) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Access to event '");
                    QualifiedName _fullyQualifiedName_1 = this.nameProvider.getFullyQualifiedName(refExp.getReference());
                    _builder_1.append((Object)_fullyQualifiedName_1);
                    _builder_1.append("' has no effect.");
                    this.error(_builder_1.toString(), (EObject)refExp, (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1, FEATURE_CALL_HAS_NO_EFFECT, new String[0]);
                } else {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Access to feature '");
                    QualifiedName _fullyQualifiedName_2 = this.nameProvider.getFullyQualifiedName(refExp.getReference());
                    _builder_2.append((Object)_fullyQualifiedName_2);
                    _builder_2.append("' has no effect.");
                    this.error(_builder_2.toString(), (EObject)refExp, (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1, FEATURE_CALL_HAS_NO_EFFECT, new String[0]);
                }
            }
        }
    }

    protected void checkFeatureCallEffect(FeatureCall call) {
        if (call.getFeature() != null && !(call.getFeature() instanceof Operation)) {
            EObject _feature = call.getFeature();
            if (_feature instanceof Property) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Access to property '");
                QualifiedName _fullyQualifiedName = this.nameProvider.getFullyQualifiedName(call.getFeature());
                _builder.append((Object)_fullyQualifiedName);
                _builder.append("' has no effect.");
                this.error(_builder.toString(), (EObject)call, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1, FEATURE_CALL_HAS_NO_EFFECT, new String[0]);
            } else {
                EObject _feature_1 = call.getFeature();
                if (_feature_1 instanceof Event) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Access to event '");
                    QualifiedName _fullyQualifiedName_1 = this.nameProvider.getFullyQualifiedName(call.getFeature());
                    _builder_1.append((Object)_fullyQualifiedName_1);
                    _builder_1.append("' has no effect.");
                    this.error(_builder_1.toString(), (EObject)call, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1, FEATURE_CALL_HAS_NO_EFFECT, new String[0]);
                } else {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Access to feature '");
                    QualifiedName _fullyQualifiedName_2 = this.nameProvider.getFullyQualifiedName(call.getFeature());
                    _builder_2.append((Object)_fullyQualifiedName_2);
                    _builder_2.append("' has no effect.");
                    this.error(_builder_2.toString(), (EObject)call, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1, FEATURE_CALL_HAS_NO_EFFECT, new String[0]);
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkNotReactingOnsubmachinesInEvent(ReactionTrigger reaction) {
        Consumer<RegularEventSpec> _function = trigger -> {
            EObject event = this._expressionExtensions.featureOrReference(trigger.getEvent());
            if (event instanceof EventDefinition && Objects.equals(((EventDefinition)event).getDirection(), Direction.IN) && this._statechartUtil.isMultiSM(((EventDefinition)event).eContainer())) {
                String _name = ((EventDefinition)event).getName();
                String _plus = REACTING_ON_SUBMACHINES_IN_EVENT + _name;
                this.error(_plus, (EObject)trigger, null, REACTING_ON_SUBMACHINES_IN_EVENT_CODE, new String[0]);
            }
        };
        Iterables.filter((Iterable)reaction.getTriggers(), RegularEventSpec.class).forEach(_function);
    }

    @Check(value=CheckType.FAST)
    public void checkSelfTransitionInfiniteLoop(ReactionTrigger reaction) {
        boolean _tripleNotEquals;
        boolean _not_1;
        boolean _not;
        boolean _isSuperStep = this._statechartAnnotations.isSuperStep(this._sTextExtensions.getStatechart((EObject)reaction));
        boolean bl = _not = !_isSuperStep;
        if (_not) {
            return;
        }
        boolean _isSelfTransition = this.isSelfTransition(reaction.eContainer());
        boolean bl2 = _not_1 = !_isSelfTransition;
        if (_not_1) {
            return;
        }
        Guard _guard = reaction.getGuard();
        boolean bl3 = _tripleNotEquals = _guard != null;
        if (_tripleNotEquals) {
            return;
        }
        Consumer<RegularEventSpec> _function = trigger -> this.warning(String.format(SELF_TRANSITION_INFINITE_LOOP, "event"), (EObject)trigger, null, SELF_TRANSITION_INFINITE_LOOP_CODE, new String[0]);
        Iterables.filter((Iterable)reaction.getTriggers(), RegularEventSpec.class).forEach(_function);
        Consumer<AlwaysEvent> _function_1 = trigger -> this.warning(String.format(SELF_TRANSITION_INFINITE_LOOP, "always"), (EObject)trigger, null, SELF_TRANSITION_INFINITE_LOOP_CODE, new String[0]);
        Iterables.filter((Iterable)reaction.getTriggers(), AlwaysEvent.class).forEach(_function_1);
    }

    protected boolean _isSelfTransition(EObject it) {
        return false;
    }

    protected boolean _isSelfTransition(Transition t) {
        Vertex _target;
        Vertex _source = t.getSource();
        return _source == (_target = t.getTarget());
    }

    protected URI getContextElementURI() {
        URI _xblockexpression = null;
        EObject fake = super.getCurrentObject();
        _xblockexpression = EcoreUtil.getURI((EObject)this._sTextExtensions.getContextElement(fake));
        return _xblockexpression;
    }

    @XbaseGenerated
    protected boolean isSelfTransition(EObject t) {
        if (t instanceof Transition) {
            return this._isSelfTransition((Transition)t);
        }
        if (t != null) {
            return this._isSelfTransition(t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }
}

