/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.inject.Inject;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Type;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class VariableValidator
extends STextBaseValidator {
    @Inject
    ExpressionExtensions expressionExtensions;
    public static String VARIABLE_ASSIGNED_TO_TYPE = "Cannot assign a type to a variable (did you mean to use \"alias %s : %s\"?).";

    @Check(value=CheckType.FAST)
    public void checkVariableDefinition(VariableDefinition definition) {
        Expression value = definition.getInitialValue();
        if (value == null) {
            return;
        }
        EObject referencedValue = this.expressionExtensions.featureOrReference(value);
        if (referencedValue instanceof Type) {
            String message = String.format(VARIABLE_ASSIGNED_TO_TYPE, definition.getName(), ((Type)referencedValue).getName());
            this.error(message, null);
        }
    }
}

