/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.execution;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.IExecutionFlowGenerator;
import com.yakindu.sct.generator.core.execution.AbstractGeneratorEntryExecutor;
import com.yakindu.sct.generator.core.execution.FlowOptimizerFactory;
import com.yakindu.sct.generator.core.execution.IGeneratorEntryExecutor;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.transformation.FlowOptimizer;
import com.yakindu.sct.model.sexec.transformation.IModelSequencer;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class SExecGeneratorEntryExecutor
extends AbstractGeneratorEntryExecutor
implements IGeneratorEntryExecutor {
    private static final String SEXEC_FILE_EXTENSION = "sexec";
    @Inject
    private IExecutionFlowGenerator generator;
    @Inject
    private IModelSequencer sequencer;
    @Inject
    private FlowOptimizerFactory optimizerFactory;
    @Inject
    protected ICoreLibraryHelper helper;

    @Override
    protected void execute(ISCTFileSystemAccess access, GeneratorEntry generatorEntry) {
        ExecutionFlow flow = this.createExecutionFlow(generatorEntry);
        this.generator.generate(flow, generatorEntry, access);
        if (this.helper.serializeExecutionFlow(generatorEntry)) {
            this.serializeExecutionFlow(generatorEntry, flow);
        }
    }

    protected ExecutionFlow createExecutionFlow(GeneratorEntry entry) {
        ExecutionFlow flow = this.sequencer.transform((Statechart)entry.getElementRef());
        Assert.isNotNull((Object)flow, (String)"Error creation ExecutionFlow");
        FlowOptimizer optimizer = this.optimizerFactory.create(entry);
        return optimizer.optimize(flow);
    }

    protected void serializeExecutionFlow(GeneratorEntry entry, ExecutionFlow flow) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = entry.getElementRef().eResource().getURI().trimFileExtension().appendFileExtension(SEXEC_FILE_EXTENSION);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)flow);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

