/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.features;

import com.yakindu.sct.generator.core.library.impl.CoreLibraryDefaultFeatureValueProvider;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sct.model.sgraph.Statechart;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CDefaultFeatureValueProvider
extends CoreLibraryDefaultFeatureValueProvider {
    private static final String VALID_IDENTIFIER_REGEX = "[_a-zA-Z][_a-zA-Z0-9]*";

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return "C Generator".equals(library.getName());
    }

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        super.setDefaultValue(featureType, parameterValue, contextElement);
        Statechart statechart = (Statechart)this.unwrap(contextElement);
        String parameterName = parameterValue.getParameter().getName();
        if ("moduleName".equals(parameterName)) {
            parameterValue.setValue(this.asIdentifier(statechart.getName(), "_"));
        } else if ("statemachinePrefix".equals(parameterName)) {
            parameterValue.setValue(StringExtensions.toFirstLower((String)this.asIdentifier(statechart.getName(), "_")));
        } else if ("separator".equals(parameterName)) {
            parameterValue.setValue("_");
        } else if ("headerFilenameExtension".equals(parameterName)) {
            parameterValue.setValue("h");
        } else if ("sourceFilenameExtension".equals(parameterName)) {
            parameterValue.setValue("c");
        } else if ("enterState".equals(parameterName)) {
            parameterValue.setValue(true);
        } else if ("exitState".equals(parameterName)) {
            parameterValue.setValue(true);
        } else if ("generic".equals(parameterName)) {
            parameterValue.setValue(false);
        } else if ("useRelativePaths".equals(parameterName)) {
            parameterValue.setValue(true);
        } else if ("generateAllSpecifiedIncludes".equals(parameterName)) {
            parameterValue.setValue(false);
        } else if ("userAllocatedQueue".equals(parameterName)) {
            parameterValue.setValue(false);
        } else if ("metaSource".equals(parameterName)) {
            parameterValue.setValue(false);
        }
    }

    public IStatus validateParameterValue(FeatureParameterValue parameter) {
        IStatus superResult = super.validateParameterValue(parameter);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        String parameterName = parameter.getParameter().getName();
        if ("moduleName".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid module name");
            }
        } else if ("statemachinePrefix".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid function prefix name");
            }
        } else if ("separator".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid separator");
            }
        } else if ("headerFilenameExtension".equals(parameterName) ? !parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX) : "sourceFilenameExtension".equals(parameterName) && !parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
            return this.error("Invalid filename extension");
        }
        return Status.OK_STATUS;
    }

    private String asIdentifier(String it, String separator) {
        return it.replaceAll("[[^a-z]&&[^A-Z]&&[^0-9]]", separator);
    }
}

