/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.validation;

import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.util.SGgraphUtil;
import com.yakindu.sct.model.sgraph.validation.AbstractSGraphValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ChoiceValidator
extends AbstractSGraphValidator {
    public static final String CHOICE_TRANSITIONS_REQUIRE_N_OUT_MSG = "A choice must have at least one outgoing transition.";
    public static final String CHOICE_TRANSITIONS_REQUIRE_N_OUT_CODE = "choice.transitions.RequireNOut";
    public static final String CHOICE_FROM_SYNC_DONT_GO_OUT_MSG = "Since this choice targeted from a synchronization node that forks, outgoing transitions must not leave the composite state.";
    public static final String CHOICE_FROM_SYNC_DONT_GO_OUT_CODE = "choice.transitions.FromSyncToChoiceNoOutgoingTrans";

    @Check(value=CheckType.FAST)
    public void checkChoiceTransitionsRequireNOut(Choice it) {
        boolean _equals;
        int _size = it.getOutgoingTransitions().size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            this.error(CHOICE_TRANSITIONS_REQUIRE_N_OUT_MSG, (EObject)it, null, -1, CHOICE_TRANSITIONS_REQUIRE_N_OUT_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkChoiceFromSyncDontTargetOutside(Choice it) {
        if (IterableExtensions.exists(it.getIncomingTransitions(), t -> t.getSource() instanceof Synchronization && t.getSource().getOutgoingTransitions().size() > 2) && !SGgraphUtil.areOrthogonal(ListExtensions.map(it.getOutgoingTransitions(), it_1 -> it_1.getTarget()))) {
            this.error(CHOICE_FROM_SYNC_DONT_GO_OUT_MSG, (EObject)it, null, -1, CHOICE_FROM_SYNC_DONT_GO_OUT_CODE, new String[0]);
        }
    }
}

