/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.model.presenter;

import com.yakindu.base.gmf.runtime.highlighting.HighlightingParameters;
import com.yakindu.base.gmf.runtime.highlighting.IHighlightingSupport;
import com.yakindu.sct.simulation.ui.SimulationActivator;
import com.yakindu.sct.simulation.ui.model.presenter.IDynamicNotationHandler;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractDynamicNotationHandler
implements IDynamicNotationHandler,
IPropertyChangeListener {
    public static HighlightingParameters TRANSITION_PARAMS = new HighlightingParameters(ColorConstants.darkGreen, ColorConstants.gray);
    public static HighlightingParameters STATE_HIGHLIGHT_PARAMS = HighlightingParameters.DEFAULT;
    public static HighlightingParameters VERTEX_TRANSIENT_PARAMS = new HighlightingParameters(ColorConstants.darkGreen, ColorConstants.green);
    public static HighlightingParameters SUSPENDED_PARAMS = new HighlightingParameters(ColorConstants.green, HighlightingParameters.DEFAULT.backgroundFadingColor);
    protected static final IHighlightingSupport NULL_SUPPORT = new IHighlightingSupport.HighlightingSupportNullImpl();
    private IHighlightingSupport support = new IHighlightingSupport.HighlightingSupportNullImpl();

    public AbstractDynamicNotationHandler() {
        SimulationActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.updatePreferences();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("stateBackgroundHighlightingColor".equals(event.getProperty()) || "transitionHighlightingColor".equals(event.getProperty()) || "stateForegroundHighlightingColor".equals(event.getProperty())) {
            this.updatePreferences();
        }
    }

    protected void updatePreferences() {
        IPreferenceStore store = SimulationActivator.getDefault().getPreferenceStore();
        RGB foregroundColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"stateForegroundHighlightingColor");
        RGB backgroundColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"stateBackgroundHighlightingColor");
        RGB vertexForegroundColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"vertexForegroundTransientColor");
        RGB vertexBackgroundColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"vertexBackgroundTransientColor");
        RGB transitionColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"transitionHighlightingColor");
        AbstractDynamicNotationHandler.STATE_HIGHLIGHT_PARAMS.foregroundFadingColor = new Color((Device)Display.getDefault(), foregroundColor);
        AbstractDynamicNotationHandler.SUSPENDED_PARAMS.backgroundFadingColor = AbstractDynamicNotationHandler.STATE_HIGHLIGHT_PARAMS.backgroundFadingColor = new Color((Device)Display.getDefault(), backgroundColor);
        AbstractDynamicNotationHandler.SUSPENDED_PARAMS.foregroundFadingColor = ColorConstants.green;
        AbstractDynamicNotationHandler.VERTEX_TRANSIENT_PARAMS.foregroundFadingColor = new Color((Device)Display.getDefault(), vertexForegroundColor);
        AbstractDynamicNotationHandler.VERTEX_TRANSIENT_PARAMS.backgroundFadingColor = new Color((Device)Display.getDefault(), vertexBackgroundColor);
        AbstractDynamicNotationHandler.TRANSITION_PARAMS.foregroundFadingColor = new Color((Device)Display.getDefault(), transitionColor);
    }

    @Override
    public IHighlightingSupport getHighlightingSupport() {
        return this.support;
    }

    @Override
    public void setHighlightingSupport(IHighlightingSupport support) {
        this.support = support;
    }
}

