/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.core;

import com.yakindu.core.ITimed;
import com.yakindu.core.ITimerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimerService
implements ITimerService {
    private final Timer timer = new Timer();
    private final List<TimeEventTask> timerTaskList = new ArrayList<TimeEventTask>();
    private final Lock lock = new ReentrantLock();

    @Override
    public void setTimer(ITimed callback, int eventID, long time, boolean isPeriodic) {
        TimeEventTask timerTask = new TimeEventTask(callback, eventID);
        this.lock.lock();
        this.timerTaskList.add(timerTask);
        if (isPeriodic) {
            this.timer.scheduleAtFixedRate((TimerTask)timerTask, time, time);
        } else {
            this.timer.schedule((TimerTask)timerTask, time);
        }
        this.lock.unlock();
    }

    @Override
    public void unsetTimer(ITimed callback, int eventID) {
        this.lock.lock();
        int index = this.timerTaskList.indexOf(new TimeEventTask(callback, eventID));
        if (index != -1) {
            this.timerTaskList.get(index).cancel();
            this.timer.purge();
            this.timerTaskList.remove(index);
        }
        this.lock.unlock();
    }

    public void cancel() {
        this.lock.lock();
        this.timer.cancel();
        this.timer.purge();
        this.lock.unlock();
    }

    private class TimeEventTask
    extends TimerTask {
        private ITimed callback;
        int eventID;

        public TimeEventTask(ITimed callback, int eventID) {
            this.callback = callback;
            this.eventID = eventID;
        }

        @Override
        public void run() {
            this.callback.raiseTimeEvent(this.eventID);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TimeEventTask) {
                return ((TimeEventTask)obj).callback.equals(this.callback) && ((TimeEventTask)obj).eventID == this.eventID;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int prime = 37;
            int result = 1;
            int c = this.eventID;
            result = prime * result + c;
            c = this.callback.hashCode();
            result = prime * result + c;
            return result;
        }
    }
}

