/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.editor.figures.utils;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Path;

public class GraphicsUtil {
    public static void fillVerticalGradientRectangle(Graphics graphics, Rectangle bounds, Color c1, Color c2) {
        graphics.pushState();
        graphics.setForegroundColor(c2);
        graphics.setBackgroundColor(c1);
        graphics.fillGradient(bounds.x, bounds.y, bounds.width, bounds.height, true);
        graphics.popState();
    }

    public static void fillVerticalGradientRoundedRectangle(Graphics graphics, Rectangle bounds, Dimension corner, Color c1, Color c2) {
        graphics.pushState();
        graphics.setForegroundColor(c2);
        graphics.setBackgroundColor(c1);
        graphics.fillGradient(bounds.x, bounds.y + (corner.height >> 1), bounds.width, bounds.height - corner.height, true);
        Path p = new Path(null);
        p.addArc((float)bounds.x, (float)(bounds.y + bounds.height - corner.height - 1), (float)corner.width, (float)corner.height, 180.0f, 90.0f);
        p.addArc((float)(bounds.x + bounds.width - corner.width - 1), (float)(bounds.y + bounds.height - corner.height - 1), (float)corner.width, (float)corner.height, 270.0f, 90.0f);
        graphics.fillPath(p);
        p.dispose();
        p = new Path(null);
        graphics.setBackgroundColor(c2);
        p.addArc((float)(bounds.x + bounds.width - corner.width - 1), (float)bounds.y, (float)corner.width, (float)corner.height, 0.0f, 90.0f);
        p.addArc((float)bounds.x, (float)bounds.y, (float)corner.width, (float)corner.height, 90.0f, 90.0f);
        graphics.fillPath(p);
        p.dispose();
        graphics.popState();
    }

    public static Color mixColor(Color baseColor, Color mixinColor, int ratio) {
        return new Color(baseColor.getDevice(), baseColor.getRed() + (mixinColor.getRed() - baseColor.getRed()) * ratio / 255, baseColor.getGreen() + (mixinColor.getGreen() - baseColor.getGreen()) * ratio / 255, baseColor.getBlue() + (mixinColor.getBlue() - baseColor.getBlue()) * ratio / 255);
    }
}

