/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.proposals;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.ui.editor.StatechartImages;
import com.yakindu.sct.ui.editor.proposals.IEditProposal;
import com.yakindu.sct.ui.editor.proposals.IEditProposalProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class ContentProposalHandler
implements IContentProposalProvider {
    @Inject
    protected Set<IEditProposalProvider> proposalProviders;
    protected GraphicalViewer viewer;
    private IControlContentAdapter proposalControlAdapter;
    private ILabelProvider proposalLabelProvider;

    public ContentProposalHandler(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.proposalControlAdapter = new ProposalControlAdapter();
        this.proposalLabelProvider = new ProposalLabelProvider();
    }

    public IControlContentAdapter getProposalControlAdapter() {
        return this.proposalControlAdapter;
    }

    public ILabelProvider getProposalLabelProvider() {
        return this.proposalLabelProvider;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        this.initProposalProvidersOnDemand();
        List<IEditProposal> editProposals = this.collectEditProposals();
        editProposals = this.sort(editProposals);
        return this.contentProposalsFrom(editProposals);
    }

    protected void initProposalProvidersOnDemand() {
        IDomain domain;
        if (this.proposalProviders == null && this.getSelectedView() != null && (domain = DomainRegistry.getDomain((EObject)this.getSelectedView().getElement())) != null) {
            Injector injector = domain.getInjector("com.yakindu.sct.editor", new String[0]);
            injector.injectMembers((Object)this);
        }
    }

    protected List<IEditProposal> collectEditProposals() {
        ArrayList<IEditProposal> proposals = new ArrayList<IEditProposal>();
        View selectedView = this.getSelectedView();
        if (selectedView != null && this.proposalProviders != null) {
            for (IEditProposalProvider provider : this.proposalProviders) {
                for (IEditProposal editProposal : provider.getProposals(selectedView)) {
                    if (!editProposal.isApplicable()) continue;
                    proposals.add(editProposal);
                }
            }
        }
        return proposals;
    }

    protected View getSelectedView() {
        View selectedView = null;
        if (this.viewer.getSelectedEditParts().size() > 0 && this.viewer.getSelectedEditParts().get(0) instanceof IGraphicalEditPart) {
            selectedView = ((IGraphicalEditPart)this.viewer.getSelectedEditParts().get(0)).getNotationView();
        }
        return selectedView;
    }

    protected List<IEditProposal> sort(List<IEditProposal> proposals) {
        return proposals;
    }

    protected IContentProposal[] contentProposalsFrom(List<IEditProposal> editProposals) {
        IContentProposal[] contentProposals = new IContentProposal[editProposals.size()];
        int i = 0;
        while (i < editProposals.size()) {
            contentProposals[i] = new EditProposalWrapper(editProposals.get(i));
            ++i;
        }
        return contentProposals;
    }

    protected IEditProposal getProposalById(String id) {
        List<IEditProposal> editProposals = this.collectEditProposals();
        if (id != null) {
            for (IEditProposal editProposal : editProposals) {
                if (!id.equals(editProposal.getId())) continue;
                return editProposal;
            }
        }
        return null;
    }

    protected static class EditProposalWrapper
    extends ContentProposal {
        protected IEditProposal wrappedProposal;

        public EditProposalWrapper(IEditProposal editProposal) {
            super(editProposal.getId(), editProposal.getLabel(), editProposal.getDescription());
            this.wrappedProposal = editProposal;
        }

        public IEditProposal getEditProposal() {
            return this.wrappedProposal;
        }
    }

    protected class ProposalControlAdapter
    implements IControlContentAdapter {
        protected ProposalControlAdapter() {
        }

        public org.eclipse.swt.graphics.Rectangle getInsertionBounds(Control control) {
            IFigure figure = ((IGraphicalEditPart)ContentProposalHandler.this.viewer.getSelectedEditParts().get(0)).getFigure();
            Rectangle bounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)bounds);
            return new org.eclipse.swt.graphics.Rectangle(bounds.getTopRight().x, bounds.getTopRight().y, 100, 0);
        }

        public void insertControlContents(Control control, String id, int cursorPosition) {
            IEditProposal proposal = ContentProposalHandler.this.getProposalById(id);
            if (proposal.isApplicable()) {
                proposal.apply();
            }
        }

        public String getControlContents(Control control) {
            return "";
        }

        public int getCursorPosition(Control control) {
            return 0;
        }

        public void setCursorPosition(Control control, int index) {
        }

        public void setControlContents(Control control, String contents, int cursorPosition) {
        }
    }

    public static class ProposalLabelProvider
    extends LabelProvider {
        protected Image defaultImage = StatechartImages.SUB_STATECHART_PICTOGRAM.image();

        public String getText(Object element) {
            if (element instanceof IContentProposal) {
                return ((IContentProposal)element).getLabel();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof EditProposalWrapper) {
                image = ((EditProposalWrapper)((Object)element)).getEditProposal().getImage();
            }
            return image != null ? image : this.defaultImage;
        }
    }
}

