/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.validation;

import com.google.common.collect.Lists;
import com.yakindu.sct.ui.editor.validation.ValidationJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;

public class ShadowModelValidationJob
extends ValidationJob {
    @Override
    protected IStatus runInternal(IProgressMonitor monitor) {
        ResourceSetImpl set = new ResourceSetImpl();
        try {
            if (!this.resource.isLoaded()) {
                return Status.CANCEL_STATUS;
            }
            Resource shadowResource = set.createResource(this.resource.getURI());
            this.cloneResource(monitor, shadowResource);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ArrayList issues = Lists.newArrayList();
            try {
                issues.addAll(this.doValidation(monitor, shadowResource));
            }
            catch (Throwable ex) {
                return Status.CANCEL_STATUS;
            }
            this.validationIssueProcessor.processIssues((List)issues, monitor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Status(4, "com.yakindu.sct.ui.editor", ex.getMessage());
        }
        return Status.OK_STATUS;
    }

    protected List<Issue> doValidation(final IProgressMonitor monitor, Resource shadowResource) {
        return this.validator.validate(shadowResource, CheckMode.FAST_ONLY, new CancelIndicator(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        });
    }

    protected void cloneResource(IProgressMonitor monitor, Resource shadowResource) throws ExecutionException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            TransactionUtil.getEditingDomain((Resource)this.resource).runExclusive(() -> {
                try {
                    XMISaveImpl saver = new XMISaveImpl((XMLHelper)new XMIHelperImpl((XMLResource)this.resource));
                    saver.save((XMLResource)this.resource, (OutputStream)bout, Collections.emptyMap());
                    bout.flush();
                }
                catch (Throwable tt) {
                    tt.printStackTrace();
                }
            });
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            shadowResource.load((InputStream)new ByteArrayInputStream(bout.toByteArray()), Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

