/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LambdaOperator implements Enumerator
{
    LAMBDA(0, "lambda", "=>"),
    HYPHEN_LAMBDA(1, "hyphenLambda", "->"),
    COLON_LAMBDA(2, "colonLambda", ":");

    public static final int LAMBDA_VALUE = 0;
    public static final int HYPHEN_LAMBDA_VALUE = 1;
    public static final int COLON_LAMBDA_VALUE = 2;
    private static final LambdaOperator[] VALUES_ARRAY;
    public static final List<LambdaOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LambdaOperator[]{LAMBDA, HYPHEN_LAMBDA, COLON_LAMBDA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LambdaOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LambdaOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LambdaOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LambdaOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LambdaOperator get(int value) {
        switch (value) {
            case 0: {
                return LAMBDA;
            }
            case 1: {
                return HYPHEN_LAMBDA;
            }
            case 2: {
                return COLON_LAMBDA;
            }
        }
        return null;
    }

    private LambdaOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

