/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.debugging.ui;

import com.google.inject.Injector;
import com.yakindu.base.expressions.expressions.Guard;
import com.yakindu.base.xtext.utils.jface.fieldassist.CompletionProposalAdapter;
import com.yakindu.base.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.simulation.debugging.ISCTBreakpoint;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;

public class SCTBreakpointDetailPane
implements IDetailPane {
    public static final String SCT_BREAKPOINT_PANE = "sctBreakpointPane";
    private StyledTextXtextAdapter adapter;
    private Statechart statechart;
    private ISCTBreakpoint breakpoint;
    private StyledText text;
    private Button conditional;
    private Composite parent;
    private String domainID;

    public void init(IWorkbenchPartSite partSite) {
    }

    public Control createControl(Composite parent) {
        parent.setBackground(ColorConstants.white);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createCheckBox(composite);
        return composite;
    }

    protected void createCheckBox(Composite parent) {
        this.parent = parent;
        this.conditional = new Button(parent, 32);
        this.conditional.setText("Conditional (Suspend when expression is 'true')");
        this.conditional.setSelection(false);
        this.conditional.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCTBreakpointDetailPane.this.text.setEnabled(!SCTBreakpointDetailPane.this.text.getEnabled());
                SCTBreakpointDetailPane.this.updateTextBackground();
                SCTBreakpointDetailPane.this.breakpoint.setConditional(SCTBreakpointDetailPane.this.text.isEnabled());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.conditional);
    }

    protected void updateTextBackground() {
        if (this.text.isEnabled()) {
            this.text.setBackground(ColorConstants.white);
        } else {
            this.text.setBackground(Display.getDefault().getSystemColor(22));
        }
    }

    protected void createTextArea(Composite parent) {
        this.text = new StyledText(parent, 2818);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.text);
    }

    protected void enableXtext() {
        IDomain domain = DomainRegistry.getDomain((EObject)this.statechart);
        if (this.domainID == null || !this.domainID.equals(domain.getDomainID())) {
            if (this.text != null) {
                this.text.dispose();
            }
            this.createTextArea(this.parent);
            this.domainID = domain.getDomainID();
            Injector embeddedEditorInjector = domain.getInjector("com.yakindu.sct.editor", new String[]{Guard.class.getName()});
            this.adapter = new StyledTextXtextAdapter(embeddedEditorInjector);
            this.adapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)new ContextElementAdapter((EObject)this.statechart));
            this.adapter.adapt(this.text);
            final CompletionProposalAdapter completionAdapter = new CompletionProposalAdapter((Control)this.text, this.adapter.getContentAssistant(), KeyStroke.getInstance((int)262144, (int)32), null);
            this.text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (!completionAdapter.isProposalPopupOpen()) {
                        SCTBreakpointDetailPane.this.breakpoint.setExpression(SCTBreakpointDetailPane.this.text.getText());
                    }
                }
            });
        } else {
            ContextElementAdapter existingAdapter = (ContextElementAdapter)EcoreUtil.getExistingAdapter((Notifier)this.adapter.getFakeResourceContext().getFakeResource(), ContextElementAdapter.class);
            existingAdapter.setElement((EObject)this.statechart);
        }
    }

    public void dispose() {
        this.adapter.dispose();
        this.conditional.dispose();
        this.text.dispose();
    }

    public void display(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            this.text.setText("");
            this.text.setEnabled(false);
            this.conditional.setEnabled(false);
            return;
        }
        this.conditional.setEnabled(true);
        this.breakpoint = (ISCTBreakpoint)selection.getFirstElement();
        if (this.breakpoint == null) {
            return;
        }
        EObject semanticObject = this.breakpoint.resolveSemanticElement();
        this.statechart = (Statechart)EcoreUtil.getRootContainer((EObject)semanticObject);
        this.conditional.setSelection(this.breakpoint.isConditional());
        this.enableXtext();
        this.text.setEnabled(this.breakpoint.isConditional());
        this.text.setText(this.breakpoint.getExpression());
        this.updateTextBackground();
        this.text.getShell().layout(new Control[]{this.text}, 4);
    }

    public boolean setFocus() {
        this.text.setFocus();
        return true;
    }

    public String getID() {
        return SCT_BREAKPOINT_PANE;
    }

    public String getName() {
        return "SCT Breakpoint Details";
    }

    public String getDescription() {
        return this.getName();
    }

    public EObject getContextObject() {
        return this.statechart;
    }
}

