/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.yakindu.base.types.AnnotatableElement

/**
 * Defines the standard code pattern for generating C# attribute assignments. These C# attributes are derived from the type system annotations.
 * 
 * @author Axel Terfloth
 */
class AttributeCode {
	
	def CharSequence attributeCode(AnnotatableElement it) '''
		«IF ! codeAnnotations.isNullOrEmpty»«FOR a : codeAnnotations»
		[«a.type.name»]
		«ENDFOR»
		«ENDIF»
	'''
	
	def protected codeAnnotations(AnnotatableElement it) {
		annotations.filter[ a | ! a.type.name.startsWith('_')]
	}
}