/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml.modifications

import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.StextFactory

/**
 * Replaces
 * 
 * 	interface Named:
 * 		var x : integer
 * to
 * 
 * interface:
 * 	var named_x : integer
 * 
 * Since variables may not contain '.' in qualifiers 
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class NamedInterfaceModification implements IModification {

	override modify(Statechart statechart) {
		val declarations = statechart.scopes.filter(InterfaceScope).filter[name !== null].map[declarations].flatten.
			filter(com.yakindu.base.types.Property).toList
		declarations.forEach [
			name = '''«(eContainer as InterfaceScope).name»_«name»'''
			statechart.defaultInterfaceScope.declarations.add(it)
		]
	}

	def getDefaultInterfaceScope(Statechart it) {
		it.scopes.filter(InterfaceScope).findFirst[name.nullOrEmpty] ?: {
			var defaultScope = StextFactory.eINSTANCE.createInterfaceScope
			it.scopes.add(defaultScope)
			defaultScope
		}
	}

}
