/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.extensions

/**
 * Derive model sequencer configuration from core generator entries.
 * 
 * @author axel terfloth
 */
import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.model.sexec.transformation.config.DefaultFlowConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper

@Singleton
class CoreFlowConfiguration extends DefaultFlowConfiguration {
	
	@Inject protected GeneratorEntry entry
	@Inject extension ICoreLibraryHelper 
	
	override configureForStatechart(Statechart sc) {
		super.configureForStatechart(sc)
		_applyOutgoingEventBuffer = entry.outEventGettersUsed
	}
}