/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class Types implements IContentTemplate<ExecutionFlow> {

	@Inject protected extension CppFileNaming
	@Inject protected extension GenmodelEntries
	@Inject protected extension CppTypes
	@Inject protected extension Literals

	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#ifndef «typesModule.define»_H_
		#define «typesModule.define»_H_
		
		/* As <cstdint> is not available on all platforms we choose to include <stdint.h>. You can switch to <cstdint> by commenting and uncommenting the lines below.*/
		// #include <cstdint>
		#include <stdint.h>
		
		#ifndef «sc_string.name»
		#define «sc_string.name»      char*
		#endif
		
		typedef int_fast16_t   «sc_short.name»;
		typedef uint_fast16_t  «sc_ushort.name»;
		typedef int32_t        «sc_integer.name»;
		typedef int16_t		   «sc_error.name»;
		typedef double         «sc_real.name»;
		typedef bool           «sc_bool.name»;
		
		typedef «entry.getTimerServiceTimeType» «sc_time.fqName»;
		
		typedef intptr_t       «sc_eventid.name»;
		
		#ifndef «NULL_LITERAL»
			#ifdef __cplusplus
				#if __cplusplus >= 201103L || (defined(_MSC_VER) && _MSC_VER >= 1900)
			  		#define «NULL_LITERAL» nullptr
				#else
					#define «NULL_LITERAL» 0
				#endif
			#else
				#define «NULL_LITERAL» ((void *)0)
			#endif
		#endif
		
		#endif /* «typesModule.define»_H_ */
	'''
	
}
