/**
 * Copyright (c) 2020-2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules

import com.google.inject.Inject
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Expression
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.FlowCode
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.StatechartScope

/**
 * @author René Beckmann
 * @author Axel Terfloth
 */
class EventCode implements com.yakindu.sct.generator.core.submodules.lifecycle.EventCode {
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension GeneratorPredicate
	@Inject protected extension CppExpressionsGenerator
	@Inject protected extension EventProcessing
	@Inject protected extension ExpressionBuilder
	@Inject protected extension CppTypes
	@Inject protected extension CppSpecifiers
	@Inject protected extension INamingService
	@Inject protected extension FlowCode
	@Inject protected extension EventNaming
	
	
	
	def generateEvents(ExecutionFlow it, StatechartScope scope)
		'''
		«FOR event : scope.incomingEvents»
			«generateEventComment(event, scope)»
			«generateInterfaceEventRaiser(it, event, scope)»
		«ENDFOR»
		«FOR event : scope.outgoingEvents»
			«generateEventComment(event, scope)»
			«IF useOutEventGetters»
				«generateInterfaceEventRaised(it, event, scope)»
				«IF event.hasValue»
					«generateEventValueGetter(it, event, scope)»
				«ENDIF»
			«ENDIF»
			«IF useOutEventObservables»
				«generateObservableGetter(it, event, scope)»
			«ENDIF»
		«ENDFOR»
		«FOR event : scope.localEvents»
			«generateEventComment(event, scope)»
			«generateInterfaceEventRaiser(it, event, scope)»
		«ENDFOR»
	'''
		
	def protected generateObservableGetter(ExecutionFlow it, EventDefinition event, StatechartScope scope) {
		'''
			«scRxNS»::Observable<«event.typeSpecifier.targetLanguageName»>* «module»::«scope.scopedAccess»«event.asObservableGetter»()«_noexcept»
			{
				return &(this->«event.observable»);
			}
		'''
	}
	
	protected def CharSequence generateEventValueGetter(ExecutionFlow it, EventDefinition event, StatechartScope scope)
		'''
		«event.typeSpecifier.targetLanguageName» «module»::«scope.scopedAccess»«event.asGetter»() const«_noexcept»
		{
			return «event.localValueAccess»;
		}
	'''
	
	protected def CharSequence generateInterfaceEventRaised(ExecutionFlow it, EventDefinition event, StatechartScope scope)
		'''
		«sc_bool.fqName» «module»::«scope.scopedAccess»«event.asRaised»() const
		{
			return «event.localAccess»;
		}
	'''
		
	protected def CharSequence generateInterfaceEventRaiser(ExecutionFlow it, EventDefinition event, StatechartScope scope)
		'''
		void «module»::«scope.scopedAccess»«event.asRaiser»(«event.valueParams»)
		{
			«IF event.hasValue»
				«event.localValueAccess» = «event.asParameter»;
			«ENDIF»
			«event.localAccess» = true;
		}
	'''
	
	protected def CharSequence generateEventComment(EventDefinition it, StatechartScope scope)
		'''/* Functions for event «name» in interface «scope.interfaceName» */'''
		
	def needsRaiser(EventDefinition it) { it.isInEvent || it.isLocalEvent }
	def needsRaised(EventDefinition it) { it.isLocalEvent || (it.isOutEvent && useOutEventGetters)}
	
	override eventClearCode(ExecutionFlow flow, Expression event) '''
	«event.code» = false;
	''' 
	
	override eventMoveCode(ExecutionFlow flow, Expression source, Expression target) '''
		«target.code» = «source.code»;
		«IF source.event.hasValue»«target._meta(target.event.valueFeature).code» = «source._meta(source.event.valueFeature).code»;«ENDIF»
		«source.code» = false;
	'''
	
	override eventNextCode(ExecutionFlow flow) {
		throw new UnsupportedOperationException("Something went wrong - generating 'eventNext' not supported for cycle based statecharts.")
	}
		
	override getNextEventCode(ExecutionFlow it) {
		'''
		«dispatchEventFctID»(«nextEventFctID»())'''
	}

}
