/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.stext.stext.EventDefinition

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sexec.concepts.EventQueue

class EventDrivenInterfaceFunctions extends InterfaceFunctions {

	@Inject protected extension EventQueue

	@Inject protected extension INamingService
	@Inject protected extension GeneratorPredicate
	@Inject protected extension EventNaming
	
	override CharSequence protectedInnerClassMembers(Scope it) {
		'''
		«super.protectedInnerClassMembers(it)»
		«IF needsDispatchEventFunction(flow)»
		«sc_bool.fqName» «it.flow.dispatchEventFctIDbyScope(it)»(«it.flow.eventNamespaceName»::«SCT_EVENT» * event);
		«ENDIF»
		'''
	}
	
	override dispatch privateFunctionPrototypes(EventDefinition it) {
		'''
		«IF it.isQueued»
			/*! Raises the in event '«name»' that is defined in the «scope.scopeDescription». */
			void internal_«asRaiser»(«valueParams»);
		«ENDIF»
		'''
	}
}