/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.types

import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.generator.c.types.CTypes.PType
import com.yakindu.sct.generator.c.types.CTypes.PBoolean

/**
 * The generated C++11 code uses type definitions which are different from those of the 
 * C++98 code generator.
 * 
 * @author axel terfloth - Initial contribution.
 */
class Cpp11Types extends CppTypes {

	public static final PType SC_STRING = new PString("std", "string")
	public static final PType SC_STRING_LITERAL = new CString("const char*")
	public static final PType SC_BOOL= new PBoolean("bool")
	
	public static final PType SC_INTEGER = new PNumber("sc", "integer")
	public static final PType SC_REAL= new PNumber("sc", "real")
	public static final PType SC_SHORT = new PNumber("sc", "short")
	public static final PType SC_USHORT = new PNumber("sc", "ushort")
	public static final PType SC_ERROR = new PNumber("sc", "errorCode")
	public static final PType SC_EVENTID = new PNumber("sc", "eventid")
	public static final PType SC_TIME = new PNumber("sc", "time")
			
	override sc_string() { SC_STRING }
	override sc_string_literal() { SC_STRING_LITERAL }
	override sc_integer() { SC_INTEGER }
	override sc_real() { SC_REAL }
	override sc_bool() { SC_BOOL }
	override sc_short() { SC_SHORT }
	override sc_ushort() { SC_USHORT }
	override sc_error() { SC_ERROR }
	override sc_eventid() { SC_EVENTID }
	override sc_time() { SC_TIME }
	
	override scBoolCast() ''''''
	
}