/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator
import com.yakindu.sctunit.generator.c.extensions.GTest
import com.yakindu.sctunit.generator.c.extensions.Genmodel
import com.yakindu.sctunit.generator.c.extensions.JUnitTest
import com.yakindu.sctunit.generator.c.extensions.TimerService
import com.yakindu.sctunit.generator.c.extensions.TimerServiceHeader
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitElement
import com.yakindu.sctunit.sCTUnit.TestPackage
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * 
 * @author Markus Muehlbrandt
 * @author oliver bohl
 * @author Johannes Dicks - Refactoring based on EFS encapsulation
 * 
 */
class CSCTUnitGenerator implements ISCTUnitGenerator {

	@Inject extension JUnitTest jUnitTest
	@Inject extension CSCTUnitGenmodelEntries
	@Inject extension GTest gTest
	@Inject extension TimerService timerService
	@Inject extension TimerServiceHeader timerServiceHeader
	@Inject extension Genmodel genModel

	@Inject
	protected ICoreLibraryHelper helper

	override generate(GeneratorEntry entry, IFileSystemAccess fsa) {
		var targetProjectName = helper.getTargetProjectValue(entry).stringValue

		var String gTestOutletFolderString = entry.targetFolderString
		var TestPackage testPackage = getTestPackage(entry)

		var targetProjectPath = getJavaPackageForProjectName(targetProjectName)

		// JUnit 
		if (entry.isJUnitWrapper) {
			jUnitTest.generateJUnitTest(testPackage, fsa, targetProjectPath)
		}

		// C & sgen
		if (EcoreUtil2.getAllContentsOfType(testPackage, typeof(SCTUnitElement)).get(0) instanceof SCTUnitClass) {
			var SCTUnitClass sctunitClass = EcoreUtil2.getAllContentsOfType(testPackage, typeof(SCTUnitElement)).
				get(0) as SCTUnitClass
			gTest.generateGTest(sctunitClass, fsa, gTestOutletFolderString)
			if(entry.isSGen){
				sctunitClass.generateGenmodel(fsa);
			}	
			timerService.generateTimerService(sctunitClass, fsa, gTestOutletFolderString)
			timerServiceHeader.generateTimerServiceHeader(sctunitClass, fsa, gTestOutletFolderString)
		}
	}
}
