/**
 * Copyright (c) 2017-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.base.NamedElement
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeAlias
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypedElement
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.transformation.SequenceBuilder
import com.yakindu.sctunit.generator.base.extensions.BaseMockingExtensions
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import java.util.List
import java.util.Set
import org.eclipse.xtext.EcoreUtil2

/**
 * @author Jonathan Thoene - itemis AG
 * @author axel terfloth
 */
class MockClassExtension extends BaseMockingExtensions{
	@Inject protected extension SCTUnitCNaming
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension CNavigationExtensions
	@Inject protected extension ITypeValueProvider valueProvider
	@Inject protected extension SequenceBuilder
	@Inject protected extension Literals
	@Inject protected extension ITypeSystem
	@Inject protected extension CTypes
	
	def protected mockReturnExpressionsGenerator(){
		_baseExpressionExtensions
	}
	
	def CharSequence generateMockClass(Operation op, Set<MockingStatement> mocks, SCTUnitClass testClass) {
		val verify = !(mocks.filter(VerifyCalledStatement).toSet.nullOrEmpty)
		var mockReturnStmts = mocks.filter(MockReturnStatement).toSet
		val mockReturn = !mockReturnStmts.nullOrEmpty
		var exprs = removeMultiExpressions(mockReturnStmts.map[m|m.value].toList)
		'''
			class «operationMockClassName(op)»{
				«IF mockReturn»
					typedef «op.typeSpecifier.targetLanguageName» («operationMockClassName(op)»::*functiontype)();
				«ENDIF»
				«IF !op.parameters.nullOrEmpty»«generateParamStructForMockClass(op, mocks)»«ENDIF»
				public:
				«generateMockClassPublicInstanceVariables(op, mocks, testClass, verify, mockReturn)»
				
				«FOR expr : exprs»

					«op.typeSpecifier.targetLanguageName» «op.name»«exprs.toArray.indexOf(expr)+1»(){
						«IF !op.type.isVoid»
							return («expr»);
						«ENDIF»
					}
				«ENDFOR»
				«IF mockReturn»

					«op.defaultBehavior»
				«ENDIF»
				«IF verify»

					«calledAtLeast»
					
					«calledAtLeastOnce»
				«ENDIF»
				«IF !op.parameters.nullOrEmpty»
					«IF mockReturn»

						«op.generateSetReturnBehavior»
					«ENDIF»
					«IF verify»

						«op.calledAtLeastWithParams»
						
						«op.calledAtLeastOnceWithParams»
					«ENDIF»
				«ENDIF»
				«IF verify»

				«op.generateOperationCounter»
				«ENDIF»
				«IF mockReturn»

					«op.getBehavior»
					
					«op.setDefaultBehavior»
					
					«op.initializeBehavior»
					
				«ENDIF»
				«op.reset(verify, mockReturn)»
			};
			«op.declareOperationMockInstance»
			
		'''
	}
	
	
	def protected generateMockClassPublicInstanceVariables(Operation op, Set<MockingStatement> mocks, SCTUnitClass testClass, boolean verify, boolean mockReturn) '''
		«IF !op.parameters.nullOrEmpty && mockReturn»
			std::list<«operationMockClassName(op)»::parameters> mocks;
		«ENDIF»
		«IF !op.parameters.nullOrEmpty && verify»
			std::list<«operationMockClassName(op)»::parameters> paramCount;
		«ENDIF»
		«IF mockReturn»
			«op.typeSpecifier.targetLanguageName» («operationMockClassName(op)»::*«mockBehaviorName(op)»Default)();
		«ENDIF»
		«IF verify»
			int callCount;
		«ENDIF»
	'''
	
	def protected declareOperationMockInstance(Operation it) '''
		static «operationMockClassName»* «operationMockObjectName»;
	'''
	
	def protected CharSequence getBehavior(Operation it)
	'''
	functiontype getBehavior(«FOR param:parameters SEPARATOR ', '»const «param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR»){
		«IF !parameters.nullOrEmpty»
		parameters p;
		«FOR param: parameters»
			p.«param.name» = «param.name»;
		«ENDFOR»
		
		std::list<«operationMockClassName(it)»::parameters>::iterator i = std::find(mocks.begin(), mocks.end(), p);
		if(i != mocks.end()) {
			return  i->behavior;
		} else {
			return «mockBehaviorName(it)»Default;
		}
		«ELSE»
		return «mockBehaviorName(it)»Default;
		«ENDIF»
	}
	'''
	
	def protected CharSequence setDefaultBehavior(Operation it)
	'''
	void setDefaultBehavior(«typeSpecifier.targetLanguageName» («operationMockClassName(it)»::*defaultBehavior)()){
		«mockBehaviorName(it)»Default = defaultBehavior;
		«IF !parameters.nullOrEmpty»
		mocks.clear();
		«ENDIF»
	}
	'''
	
	def protected CharSequence initializeBehavior(Operation it)
	'''
	void initializeBehavior() {
		setDefaultBehavior(&«operationMockClassName(it)»::«name»Default);
	}
	'''
	
	def protected CharSequence reset(Operation it, boolean verify, boolean mockReturn)
	'''
	void reset() {
		«IF mockReturn»
			initializeBehavior();
		«ENDIF»
		«IF verify»
			callCount = 0;
		«ENDIF»
		«IF !parameters.nullOrEmpty»
			«IF verify»
				paramCount.clear();
			«ENDIF»
			«IF mockReturn»
				mocks.clear();
			«ENDIF»
		«ENDIF»
	}
	'''
	
	def protected CharSequence generateSetReturnBehavior(Operation it)
	'''
	void «setReturnBehavior»(«FOR param:parameters SEPARATOR ', '»const «param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR»,«typeSpecifier.targetLanguageName» («operationMockClassName(it)»::*func)()){
		parameters p;
		«FOR param: parameters»
			p.«param.name» = «param.name»;
		«ENDFOR»
		p.behavior = func;

		std::list<«operationMockClassName(it)»::parameters>::iterator i = std::find(mocks.begin(), mocks.end(), p);
		if(i != mocks.end()) {
			mocks.erase(i);
		}
		mocks.push_back(p);
	}
	'''
	
	def protected CharSequence defaultBehavior(Operation it)
	'''
	«typeSpecifier.targetLanguageName» «name»Default(){
		«IF !type.isVoid»
			«typeSpecifier.targetLanguageName» defaultValue = «type.defaultValue»;
			return (defaultValue);
		«ENDIF»
	}
	'''
	
	def protected CharSequence generateOperationCounter(Operation it)
	'''
	«IF !parameters.nullOrEmpty»
		void «name»(«FOR param : parameters SEPARATOR ', '»const «param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR») {
			++callCount;
			
			parameters p;
			«FOR param: parameters»
				p.«param.name» = «param.name»;
			«ENDFOR»
			
			std::list<«operationMockClassName(it)»::parameters>::iterator i = std::find(paramCount.begin(), paramCount.end(), p);
			if(i != paramCount.end()) {
				p.callCount = (++i->callCount);
				paramCount.erase(i);
				
			}else{
				p.callCount = 1;
			}
			paramCount.push_back(p);
		}
	«ELSE»
		void «name»() {
			++callCount;
		}
	«ENDIF»
	'''
	
	def protected CharSequence calledAtLeast()
	'''
	«sc_bool.fqName» calledAtLeast(const int times){
		return (callCount >= times);
	}
	'''
	
	def protected CharSequence calledAtLeastOnce()
	'''
	«sc_bool.fqName» calledAtLeastOnce(){
		return (callCount>0);
	}
	'''
	
	def protected CharSequence calledAtLeastWithParams(Operation it)
	'''
	«sc_bool.fqName» calledAtLeast(const int times, «FOR param : parameters SEPARATOR ', '»const «param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR»){
		parameters p;
		«FOR param: parameters»
			p.«param.name» = «param.name»;
		«ENDFOR»
		
		std::list<«operationMockClassName(it)»::parameters>::iterator i = std::find(paramCount.begin(), paramCount.end(), p);
		if(i != paramCount.end()) {
			return (i->callCount >= times);
		}else{
			return false;
		}
	}
	'''
	
	def protected CharSequence calledAtLeastOnceWithParams(Operation it)
	'''
	«sc_bool.fqName» calledAtLeastOnce(«FOR param : parameters SEPARATOR ', '»const «param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR»){
		parameters p;
		«FOR param: parameters»
			p.«param.name» = «param.name»;
		«ENDFOR»
		
		std::list<«operationMockClassName(it)»::parameters>::iterator i = std::find(paramCount.begin(), paramCount.end(), p);
		if(i != paramCount.end()) {
			return (i->callCount > 0);
		}else{
			return false;
		}
	}
	'''
	
	def protected Set<String> removeMultiExpressions(List<Expression> expressions) {
		return expressions.map[ e |
			mockReturnExpressionsGenerator.code(e).toString
		].toSet
	}
	
	def protected CharSequence functionNameForReturnStatement(MockReturnStatement it){
		val allMocks = EcoreUtil2.getContainerOfType(it,typeof(SCTUnitClass)).getAllMockStatements(operationOfMockStatement).filter(MockReturnStatement)
		val expr = value
		val allExpressions = allMocks.map[mock|mock.value].toList.removeMultiExpressions
		
		return '''«operationOfMockStatement.name»«allExpressions.toArray.indexOf(mockReturnExpressionsGenerator.code(expr).toString)+1»'''
	}
	
	def protected CharSequence generateParamStructForMockClass(Operation it, Set<MockingStatement> mocks)
	'''
		struct parameters {
			«FOR param: parameters»
				«IF param.isString»const «ENDIF»«param.typeSpecifier.targetLanguageName» «param.name»;
			«ENDFOR»
			«IF !mocks.filter(MockReturnStatement).nullOrEmpty»
				«typeSpecifier.targetLanguageName» («operationMockClassName»::*behavior)();
			«ENDIF»
			«IF !mocks.filter(VerifyCalledStatement).nullOrEmpty»
				int callCount;
			«ENDIF»
			inline bool operator==(const parameters& other) {
				return «FOR param: parameters SEPARATOR "&&"»«compareParameters(param)»«ENDFOR»;
			}
		};
	'''
	
	def CharSequence compareParameters(Parameter it) {
		if(type.typeSystem.isString(it.type)) {
			'''(strcmp(this->«name», other.«name») == 0)'''
		} else {
			'''(this->«name» == other.«name»)'''
		}
	}
	
	def boolean isString(TypedElement it) {
		type.typeSystem.isString(type)
	}
	
	def CharSequence setReturnBehavior(Operation it){
		'''set«name.toFirstUpper»Behavior'''
	}
	
	def protected getAllMockStatements(SCTUnitClass it, Operation op) {
		SCTUnitOperations.map[tc|tc.body.code].flatten.filter(MockingStatement).filter[ms|ms.operationOfMockStatement == op].toSet
	}
	
	def getOperationOfMockStatement(MockingStatement it) {
		reference.operation
	}
	
	def defaultReturn(Type type) {
		val originalType = type?.getOriginType
		val typeSystem = type.getTypeSystem
		switch (originalType) {
			case originalType === null || typeSystem.isSame(originalType, typeSystem.getType(ITypeSystem.VOID)): ''''''
			case typeSystem.isSame(originalType, typeSystem.getType(ITypeSystem.STRING)): '''return «defaultStringValue»;'''
			EnumerationType: '''return «originalType.enumerator.head.code»;'''
			case valueProvider.defaultValue(type) === null: '''return «NULL_LITERAL»;'''
			default: '''return «valueProvider.defaultValue(type).buildValue.code»;'''
		}
	}

	def CharSequence defaultValue(Type type) {
		val originalType = type?.getOriginType
		val typeSystem = type.getTypeSystem
		switch (originalType) {
			case originalType === null || typeSystem.isSame(originalType, typeSystem.getType(ITypeSystem.VOID)): ''''''
			case typeSystem.isSame(originalType, typeSystem.getType(ITypeSystem.STRING)): defaultStringValue
			EnumerationType: originalType.namespace + originalType.enumerator.head.code
			ComplexType: '''{«FOR feature : (originalType as ComplexType).features.filter(TypedDeclaration) SEPARATOR ', '»«feature.typeSpecifier.baseType.defaultValue»«ENDFOR»}'''
			case valueProvider.defaultValue(type) === null: '''«NULL_LITERAL»'''
			default: valueProvider.defaultValue(type).buildValue.code
		}
	}


	def protected defaultStringValue(){
		'''«NULL_LITERAL»'''
	}	
	
	
	def Type getBaseType(TypeSpecifier it) {
		if (getType instanceof TypeAlias) {
			(getType as TypeAlias).typeSpecifier.baseType
		} else {
			return getType
		}
	}
	
	def getNamespace(Type type) {
		EcoreUtil2.getAllContainers(type).toList.reverse.drop(1).filter(NamedElement).join("", "::", "::", [name])
	}
}