/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter

import java.util.function.Supplier
import org.eclipse.xtext.nodemodel.util.NodeModelUtils
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Expression
import com.yakindu.base.base.NamedElement

/** 
 * @author Thomas Kutz - Initial API and contribution
 */
class SlotResolutionExceptionSupplier implements Supplier<IllegalStateException> {
	Expression exp

	new(Expression exp) {
		this.exp = exp
	}

	def static SlotResolutionExceptionSupplier forContext(Expression exp) {
		return new SlotResolutionExceptionSupplier(exp)
	}

	override IllegalStateException get() {
		return new IllegalSlotResolutionException('''Could not resolve execution slot for expression «exp.toText»''')
	}

	def dispatch String toText(FeatureCall call) {
		call.owner.toText + "." + (call.feature as NamedElement).name
	}

	def dispatch String toText(ElementReferenceExpression exp) {
		exp.reference.toText
	}

	def dispatch String toText(NamedElement exp) {
		exp.name
	}

	def dispatch String toText(Expression exp) {
		val node = NodeModelUtils.getNode(exp)
		return if(node !== null) node.text.trim else exp.toString
	}

	static class IllegalSlotResolutionException extends IllegalStateException {
		new(String msg) {
			super(msg)
		}
	}

}
