/**
* Copyright (c) 2024 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Axel Terfloth - itemis AG
*
*/
package com.yakindu.sct.simulation.core.coverage

import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.sgraph.Vertex
import com.yakindu.sct.simulation.core.coverage.Measurement.StateTransitionCoverage
import com.yakindu.sct.simulation.core.coverage.Measurement.TestCaseCount

/**
 * TODO this implementation is redundant to SCTUnitMeasureCalculater. It is intended to be used for coverage measurement within statechart simulation.
 */
class MeasureCalculator {

	protected extension MeasurementExtension = new MeasurementExtension
	protected extension StatechartMeasurementBuilder = new StatechartMeasurementBuilder
	
	static val SUITE_MEASUREMENTS = "test suite coverage" 
	
	// ------- calculating all measures
	
	def void defineMeasures(Measurement it) {
		defineTestCaseCount
		defineCoverage	
	}
	
	// ------- calculating test case count
	
	def TestCaseCount defineTestCaseCount(Measurement it) {
		defineTestCaseCount(it.subject)
	}
	
	def protected TestCaseCount defineTestCaseCount(Measurement it, Object subject) {
		
		return testCaseCount
	}
	
	// ------- calculating state transition coverage
	
	def StateTransitionCoverage defineCoverage(Measurement it) {
		it.defineCoverage(it.subject)
	}
	
	def protected dispatch StateTransitionCoverage defineCoverage(Measurement it, Object subject) {
		combineAndUpdateChildMeasures(it, StateTransitionCoverage.ZERO)
	}
	
	def protected dispatch StateTransitionCoverage defineCoverage(Measurement it, Void v) {
		combineAndUpdateChildMeasures(it, StateTransitionCoverage.ZERO)
	}

	def protected dispatch StateTransitionCoverage defineCoverage(Measurement it, Vertex vertex) {
		combineAndUpdateChildMeasures(it, if(it.visits.count > 0) StateTransitionCoverage.FULLY_COVERED else StateTransitionCoverage.NOT_COVERED)
	}

	def protected dispatch StateTransitionCoverage defineCoverage(Measurement it, Transition transition) {
		combineAndUpdateChildMeasures(it, if(it.visits.count > 0) StateTransitionCoverage.FULLY_COVERED else StateTransitionCoverage.NOT_COVERED)
	}	

	protected def StateTransitionCoverage combineAndUpdateChildMeasures(Measurement it, StateTransitionCoverage overallMeasurement) {
		var result = overallMeasurement
		for (child : it.children) {
			result += child.defineCoverage
		}
		measures += result
		return result
	}
	
	
	// ------- aggregate visits
	
	
	def protected aggregateStatechartMeasurements(Measurement it) {
	
		var aggregatedMeasurements = children.filter[SUITE_MEASUREMENTS == name].head
	
		if ( aggregatedMeasurements !== null ) children.remove(aggregatedMeasurements)
		
		val statecharts = it.findAll[it.subject instanceof Statechart]
							.map[subject as Statechart]
							.toSet
							
		aggregatedMeasurements = new Measurement => [
			name = SUITE_MEASUREMENTS
		]
							
		aggregatedMeasurements.children.addAll(
			statecharts.map[ sc |
				val aggregated = sc.buildMeasurement
			
				it.findAll[it.subject === sc]
			      .forEach[ scm | 
			      	scm.findAll[visits.count !== 0]
			      	   .forEach[ m | aggregated.forSubject(m.subject).visits.count += m.visits.count]
			      ] 
			    aggregated
			])
			
		children.add(0, aggregatedMeasurements)		
		
		aggregatedMeasurements			
	}
	
	
}
