/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.generator.python.submodules.TimingFunctions
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

class EventDrivenTimingFunctions extends TimingFunctions {
	
	@Inject extension SExecExtensions
	@Inject extension EventQueue
	@Inject extension Naming
	
	override timingFunctions(ExecutionFlow flow) '''
		«IF flow.timed»
			«IF flow.requiresIncomingEventQueue»
				def time_elapsed(self, event_id):
					"""Add time events to in event queue
					"""
					if event_id in range(«flow.timeEvents.size»):
						self.in_event_queue.put(lambda: self.raise_time_event(event_id))
						self.run_cycle()
				
				def raise_time_event(self, event_id):
					"""Raise timed events using the event_id.
					"""
					self.«timeEvents»[event_id] = True
			«ELSE»
				def time_elapsed(self, event_id):
					"""Mark the corresponding time event as True.
					"""
					if event_id in range(«flow.timeEvents.size»):
						self.«timeEvents»[event_id] = True
						self.run_cycle()
			«ENDIF»

		«ENDIF»
	'''
}