/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 	Finlay Weegen - itemis AG
 */
package com.yakindu.sctunit.simulation.core.coverage;

import com.google.inject.Inject;
import com.yakindu.sct.model.sexec.ReactionFired;
import com.yakindu.sct.model.sexec.Trace;
import com.yakindu.sct.model.sexec.TraceNodeExecuted;
import com.yakindu.sct.model.sexec.TraceStateEntered;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementContext;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import com.yakindu.sct.simulation.core.sexec.interpreter.ITraceStepInterpreter;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SuppressWarnings("all")
public class ModelVisitsTraceStepInterpreter implements ITraceStepInterpreter {
  @Inject
  @Extension
  protected MeasurementExtension _measurementExtension;

  @Inject
  @Extension
  protected MeasurementContext _measurementContext;

  @Override
  public void evaluate(final Trace trace, final ExecutionContext context) {
    this.coverage(trace, context);
  }

  protected Object _coverage(final TraceStateEntered it, final ExecutionContext context) {
    this.increaseVisited(it.getState().getSourceElement());
    return null;
  }

  protected Object _coverage(final ReactionFired it, final ExecutionContext context) {
    this.increaseVisited(it.getReaction().getSourceElement());
    return null;
  }

  protected Object _coverage(final TraceNodeExecuted it, final ExecutionContext context) {
    this.increaseVisited(it.getNode().getSourceElement());
    return null;
  }

  protected Object _coverage(final EObject fallback, final ExecutionContext context) {
    return null;
  }

  protected void increaseVisited(final EObject it) {
    if ((it != null)) {
      try {
        Measurement _currentMeasurement = this._measurementContext.getCurrentMeasurement();
        Measurement _forSubject = null;
        if (_currentMeasurement!=null) {
          _forSubject=this._measurementExtension.forSubject(_currentMeasurement, it);
        }
        Measurement.Visits _visits = null;
        if (_forSubject!=null) {
          _visits=this._measurementExtension.visits(_forSubject);
        }
        if (_visits!=null) {
          _visits.increase();
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception e = (Exception)_t;
          e.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
  }

  @XbaseGenerated
  protected Object coverage(final EObject it, final ExecutionContext context) {
    if (it instanceof ReactionFired) {
      return _coverage((ReactionFired)it, context);
    } else if (it instanceof TraceNodeExecuted) {
      return _coverage((TraceNodeExecuted)it, context);
    } else if (it instanceof TraceStateEntered) {
      return _coverage((TraceStateEntered)it, context);
    } else if (it != null) {
      return _coverage(it, context);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, context).toString());
    }
  }
}
