/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * Jonathan Thoene - itemis AG
 * 
 */

package com.yakindu.sctunit.generator.java.extensions

import com.google.inject.Inject
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.sctunit.generator.java.features.JavaSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * @author jonathan thoene - Adding of functions to generate mocking statements
 * TODO: Merge with NamingExtensions from Interpreter generator
 */
class SCTUnitJavaNaming extends BaseNamingExtensions {
	
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension JavaSCTUnitGenmodelEntries
	@Inject extension Naming
	@Inject extension OriginTracing
	@Inject GeneratorEntry entry

	def statemachineClassName(Statechart it) {
		entry.statechartTypeName ?: name.statemachineName.toFirstUpper
	}
	
	def statemachineClassName(SCTUnitClass it) {
		statechart.statemachineClassName
	}

	override dispatch valueGetter(EventDefinition definition) {
		'''isRaised«definition.name.toFirstUpper»'''
	}

	def dispatch valueGetter(InterfaceScope it) {
		interfaceGetterName.replaceAll("\\(\\)", "")
	}
	
	def dispatch CharSequence valueGetter(Property prop) {
		val scope = prop.type.originTraces.filter(InterfaceScope).head
		if (scope !== null) {
			return valueGetter(scope)
		}
		return super._valueGetter(prop)
	}

	def argumentCapture(Type type) {
		'''«type.targetLanguageName.toFirstLower»Capture'''
	}

	def methodName(SCTUnitOperation it) {
		operationName
	}
}
