/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.cpp11

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sctunit.generator.cpp.extensions.CppMockClassExtension
import com.yakindu.sctunit.generator.cpp.extensions.SCTUnitCppNaming
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import java.util.Set

/**
 * The generated C++11 code handles strings differently than the C++98 code generator.
 * 
 * @author axel terfloth - Initial contribution.
 */
@Singleton
class Cpp11MockClassExtension extends CppMockClassExtension {

	@Inject extension SCTUnitCppNaming
	@Inject extension ICodegenTypeSystemAccess
	@Inject Cpp11Expressions.MockReturn mockReturnCode
	
	override protected defaultStringValue() '''""'''


	override protected CharSequence generateParamStructForMockClass(Operation it, Set<MockingStatement> mocks)
	'''
		struct parameters {
			«FOR param: parameters»
				«param.typeSpecifier.targetLanguageName» «param.name»;
			«ENDFOR»
			«IF !mocks.filter(MockReturnStatement).nullOrEmpty»
				«typeSpecifier.targetLanguageName» («operationMockClassName»::*behavior)();
			«ENDIF»
			«IF !mocks.filter(VerifyCalledStatement).nullOrEmpty»
				int callCount;
			«ENDIF»
			inline bool operator==(const parameters& other) {
				return «FOR param: parameters SEPARATOR "&&"»«compareParameters(param)»«ENDFOR»;
			}
		};
	'''

	override CharSequence compareParameters(Parameter it) 
		'''(this->«name» == other.«name»)'''
	
	
	override protected mockReturnExpressionsGenerator(){
		mockReturnCode
	}
	
}