/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.sunit.generator.csharp.nunit.codemodel

import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation

/**
 * This class is part of the NUnit extensions to the C# code model. It defines all annotations used for NUnit code generation.
 *  
 * @author axel terfloth
 */
class NUnitAnnotations {

	public static String NUNIT_TEST_FIXTURE = "TestFixture"
	public static String NUNIT_TEST = "Test"
	public static String NUNIT_IGNORE = "Ignore(\"\")"
	public static String NUNIT_SETUP = "SetUp"
	public static String NUNIT_TEAR_DOWN = "TearDown"
	
	def isTestFixture(ComplexType it) {
		getAnnotationOfType(NUNIT_TEST_FIXTURE) !== null
	}
	
	def isNUnitTest(Operation it) {
		getAnnotationOfType(NUNIT_TEST) !== null
	}
	
	def isSetUp(Operation it) {
		getAnnotationOfType(NUNIT_SETUP) !== null
	}
	
	def isNunitIgnore(Operation it) {
		getAnnotationOfType(NUNIT_IGNORE) !== null
	}
	
	def isTearDown(Operation it) {
		getAnnotationOfType(NUNIT_TEAR_DOWN) !== null
	}
	
	
}
