/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class IStatemachine {
	
	@Inject extension Naming 
	@Inject extension GenmodelEntries
	@Inject extension OutputConfigProvider
	@Inject extension ICoreLibraryHelper
	@Inject extension StringHelper
	 
	def generateIStatemachine(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + iStatemachine.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def private content(GeneratorEntry it) {
		'''
			«licenseText»
			«IF !libraryPackage.isNullOrEmpty»package «libraryPackage»;«ENDIF»
			
			/**
			 * Basic interface for state machines.
			 */
			public interface «iStatemachine()» {
			
				/**
				 * Enters the state machine. Sets the state machine into a defined state.
				 */
				public void enter();
			
				/**
				 * Exits the state machine. Leaves the state machine with a defined state.
				 */
				public void exit();
			
				/**
				 * Checks whether the state machine is active. 
				 * A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
				 */
				public boolean isActive();
			
				/**
				 * Checks whether all active states are final. 
				 * If there are no active states then the state machine is considered being inactive. In this case this method returns <code>false</code>.
				 */
				public boolean isFinal();
			}
		'''
	}
}
