/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.TimerService
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codepattern.ExpressionCode
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineNaming
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineOperationCallbacks
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ConditionalExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.expressions.expressions.LogicalAndExpression
import com.yakindu.base.expressions.expressions.LogicalOrExpression
import com.yakindu.base.expressions.expressions.MetaCall
import com.yakindu.base.expressions.expressions.ParenthesizedExpression
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ArrayTypeSpecifier
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Part
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.codemodel.StatemachineFunctions
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.BufferEvent
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

import static com.yakindu.sct.generator.core.codemodel.StateEnum.*

/**
 * @author laszlo kovacs - Initial contribution.
 */
class CsharpStatemachineExpressionCode extends ExpressionCode {
	
	static val String CONSTRUCTOR = "new"
	
	@Inject protected extension ITypeValueProvider
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension StatemachineClass
	@Inject protected extension StatemachineFunctions
	@Inject protected extension BufferEvent
	@Inject protected extension StatechartUtil
	@Inject protected extension INamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension ITypeSystem
	@Inject protected extension ITypeSystemInferrer
	@Inject protected extension EventBuffer
	@Inject protected extension ExpressionExtensions
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension StateEnum
	@Inject protected extension CsharpStatemachineOperationCallbacks
	@Inject protected extension	Literals
	@Inject protected extension TimerService
	@Inject protected extension Statechart2TypeTransformation
	
	override dispatch CharSequence code(PrimitiveValueExpression it){
		if(eContainer instanceof TypedDeclaration){
			val typedContainer = eContainer as TypedDeclaration
			if(typedContainer.typeSpecifier instanceof ArrayTypeSpecifier){
				'''new «typedContainer.typeSpecifier.asLiteral»[«super._code(it)»]'''
			}
			else super._code(it)
		}
		else super._code(it)
	}

	override dispatch CharSequence code(ConditionalExpression it) {
		if(condition.featureOrReference.userDeclared) '''(«condition.code» ?? true) ? «trueCase.code» : «falseCase.code»'''
		else super._code(it)
	}
	
	override dispatch CharSequence code(ParenthesizedExpression it) '''(«expression.code»«IF eContainer instanceof LogicalAndExpression || eContainer instanceof LogicalOrExpression» == true«ENDIF»)'''

	var List<TimeEvent> timeEvents;

	def private getTimeEvents(TimeEvent it) {
		if (timeEvents === null) {
			timeEvents = flow.timeEvents
		}
		return timeEvents
	}	
	
	override dispatch CharSequence code(InitializationExpression it) {
		
		var originType = it.infer.type

		// TODO: we always have to use a normalized / ordered argument list. we should not care about this aspect here in the 2text transformation.
		//Either names or order is correct
		if (originType !== null && originType instanceof ComplexType) {
			if(arguments.forall[a | a.parameter !== null && a.parameter.name !== null])
			'''«CONSTRUCTOR» «originType.asLiteral»(«FOR p : originType.features.filter(Property) SEPARATOR ','»«arguments.filter(pr | pr.parameter.name.equals(p.name)).head.value.code»«ENDFOR»)'''
			else
			'''«CONSTRUCTOR» «originType.asLiteral»(«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»)'''

		} 
		//For now lets be forgiving regarding inferred type, and assume that order is correct and type is correctly infered for the container
		else if(eContainer instanceof Property){
			originType = (eContainer as Property).typeSpecifier.getType
			'''«CONSTRUCTOR» «originType.asLiteral»(«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»)'''
		}
		else {
			'''/* can not determine class name for «it» */'''
		}
	}
	
	def dispatch CharSequence code(ActiveStateReferenceExpression it) 
		'''«isStateActiveName»(«value.enumerator.asLiteral»)'''
		
	override dispatch String code(ElementReferenceExpression it) {
		val ref = it.reference
		switch ref {
			Enumerator:
				return ref.symbol.toString
			Parameter:
				return ref.name
			ComplexType:
				return ref.name
			Part:
				return ref.name
			Property:
				return ref.name
			//TODO: Re-evaluate whether the last one is needed or not (should not be needed)
			Declaration:
				return codeDeclaration(ref, it).toString
		}
	}

	def dispatch String code(MetaCall it) {
		feature.metaCode(owner)
	}

	def dispatch String metaCode(EObject it, Expression exp) '''/* cant generate meta code for «it» of «exp» */'''

	def dispatch String metaCode(Property it,
		ArgumentExpression exp) '''«codeDeclaration(it, exp)»«identifier.toString.toFirstUpper»'''

	def protected codeDeclaration(Declaration it, ArgumentExpression exp) {
		switch it {
			Operation:
				return operationCall(it, exp)
			TimeEvent:
				it.code
			Enumerator case it.eContainer.isOriginStateEnum:
				return stateEnumAccess
			Declaration case exp.isComplexTypeContained:
				return exp.code
			Property:
				return identifier
			Declaration:
				return exp.featureOrReference.code
		}
	}

	def protected stateEnumAccess(Enumerator stateEnum) {
		val statechart = stateEnum.eContainer.getOriginStatechart
		val state = stateEnum.originState

		'''«statechart.name.toFirstUpper».«STATE_ENUM_NAME».«IF state !== null»«state.enumerator.asLiteral»«ELSE»«NO_STATE»«ENDIF»'''
	}

	def dispatch protected String operationCall(Method it, ArgumentExpression exp) {
		'''«code»(«exp.argCode»)'''
	}

	def dispatch protected String operationCall(Operation it, ArgumentExpression exp) {
		if (isConstructor)
			ctorCall(exp)
		else
			'''«code»(«exp.argCode»)'''
	}

	def dispatch String code(Declaration it) {
		identifier
	}
	
	def dispatch String code(Property it) {
		 name
	}
	
	def dispatch String code(Package it) {
		asLiteral
	}

	def dispatch code(TimeEvent it) {
		'''«timeEventsName»[«getTimeEvents.indexOf(it)»]'''
	}

	def protected boolean isAssignmentContained(Expression it) {
		EcoreUtil2.getContainerOfType(it, AssignmentExpression) !== null
	}

	def protected boolean isPropertyContained(Expression it) {
		EcoreUtil2.getContainerOfType(it, Property) !== null
	}

	def protected dispatch boolean isComplexTypeContained(FeatureCall it) {
		featureOrReference.eContainer instanceof ComplexType
	}

	def protected dispatch boolean isComplexTypeContained(ElementReferenceExpression it) {
		featureOrReference.eContainer instanceof ComplexType
	}

	def protected boolean isPostFixContained(Expression it) {
		EcoreUtil2.getContainerOfType(it, PostFixUnaryExpression) !== null
	}

	override dispatch CharSequence code(FloatLiteral it) '''«value.toString»F'''

	override dispatch CharSequence code(IntLiteral it) '''«value.toString»L'''
	
	def protected isConstructor(Operation it) {
		it.name == CONSTRUCTOR && static
	}
	
	def protected String ctorCall(Operation it, ArgumentExpression exp) {
		'''«CONSTRUCTOR» «it.type.name»«IF !it.typeParameters.isEmpty»<>«ENDIF»(«FOR arg : exp.expressions SEPARATOR ", "»«arg.code»«ENDFOR»)'''
	}
}