/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.python.features

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sctunit.generator.base.SCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitClass

import static com.yakindu.sctunit.generator.python.features.PythonSCTUnitFeatureConstants.*

/**
 * 
 * @author jonathan thoene - Initial contribution and API
 * 
 */
class PythonSCTUnitGenmodelEntries extends SCTUnitGenmodelEntries {
	
	@Inject extension StringHelper
	
	override getLicenseText(GeneratorEntry it) '''
		""" «licenseTextParameter?.stringValue?.trim ?: "Generated by itemis CREATE code generator."»
		"""
	'''
	
	def private getStatechartNamingFeature(GeneratorEntry it) {
		getFeatureConfiguration(STATECHART_NAMING_FEATURE)
	}
	
	def private getNamingFeature(GeneratorEntry it){
		getFeatureConfiguration(NAMING_FEATURE)
	}
	
	def private FeatureParameterValue getStatechartBasePackageParameter(GeneratorEntry it) {
		statechartNamingFeature?.getParameterValue(BASE_PACKAGE)
	}
	
	def private FeatureParameterValue getStatechartLibraryPackageParameter(GeneratorEntry it) {
		statechartNamingFeature?.getParameterValue(LIBRARY_PACKAGE)
	}

	def private FeatureParameterValue getBasePackageParameter(GeneratorEntry it){
		namingFeature?.getParameterValue(BASE_PACKAGE)
	}
	
	def private FeatureParameterValue getLibraryTargetFolderParameter(GeneratorEntry it){
		statechartNamingFeature?.getParameterValue(LIBRARY_TARGET_FOLDER)
	}
	
	def getBasePackage(GeneratorEntry it) {
		basePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT
	}
	
	def getStatechartBasePackage(GeneratorEntry it) {
		(statechartBasePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT).dot(statechart?.namespace?.toLowerCase)
	}
	
	def getStatechartBasePackage(GeneratorEntry it, Statechart context) {
		(statechartBasePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT).dot(context.namespace?.toLowerCase)
	}
	
	def getLibraryTargetFolder(GeneratorEntry it){
		libraryTargetFolderParameter?.stringValue ?: targetFolderString
	}
	
	def getBasePackagePath(GeneratorEntry it){
		basePackage.toPath
	}
	
	def getStatechartBasePackagePath(GeneratorEntry it){
		statechartBasePackage.toPath
	}
	
	def getStatechartLibraryPackage(GeneratorEntry it) {
		statechartLibraryPackageParameter?.stringValue ?: LIBRARY_PACKAGE_DEFAULT
	}
	
	def getStatechartLibraryPackagePath(GeneratorEntry it) {
		statechartLibraryPackage.toPath
	}
	
	def hasStatechartNamingFeature(GeneratorEntry it){
		return (statechartNamingFeature !== null)
	}
	
	def private getJUnitWrapperFeature(GeneratorEntry it) {
		getFeatureConfiguration(FEATURE_JUNIT_WRAP)
	}
	
	def private getJUnitWrapperParameter(GeneratorEntry it) {
		JUnitWrapperFeature?.getParameterValue(PARAMETER_JUNIT_WRAP)
	}
	
	def isJUnitWrapper(GeneratorEntry it) {
		if (JUnitWrapperParameter !== null)
			JUnitWrapperParameter.booleanValue
		else
			false
	}
	
	def getStatechart(GeneratorEntry it) {
		if (elementRef instanceof SCTUnitClass)
			return (elementRef as SCTUnitClass).statechart
		else
			null as Statechart
	}
	
}
