package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.c.types.CTypeAnnotations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations

class StringIncludeProvider implements IncludeProvider{
	
	@Inject extension CTypeAnnotations
	
	override getIncludes(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		#['''#include <string.h>''']
	}
	
	def protected hasCharArray(ExecutionFlow it){
		scopes.map[members].flatten.filter(TypedDeclaration).map[type].filter(ComplexType).exists[ct | ct.features.exists[hasCharArrayAnnotation]]
	}
	
}