/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.extensions

import com.yakindu.sct.generator.c.features.ICFeatureConstants
import com.yakindu.sct.generator.core.library.CoreGenmodelEntries
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry

class GenmodelEntries extends CoreGenmodelEntries {
		
	def private getIdentifierSettingsFeature(GeneratorEntry it) {
		getFeatureConfiguration(ICFeatureConstants::FEATURE_NAMING)
	}
	
	def private FeatureParameterValue getSeparatorParameter(GeneratorEntry it) {
		identifierSettingsFeature?.getParameterValue(ICFeatureConstants::PARAMETER_NAMING_SEPARATOR)
	}
	
	def getSeparator(GeneratorEntry it) {
		return separatorParameter?.stringValue
	}
	
	def private FeatureParameterValue getStatemachinePrefixParameter(GeneratorEntry it) {
		identifierSettingsFeature?.getParameterValue(ICFeatureConstants::PARAMETER_NAMING_STATEMACHINE_PREFIX)
	}
	
	def getStatemachinePrefix(GeneratorEntry it) {
		return statemachinePrefixParameter?.stringValue
	}
	
	def private FeatureParameterValue getModuleNameParameter(GeneratorEntry it) {
		identifierSettingsFeature?.getParameterValue(ICFeatureConstants::PARAMETER_NAMING_MODULE_NAME)
	}
	
	def getModuleName(GeneratorEntry it) {
		return moduleNameParameter?.stringValue
	}
	
	def getHeaderFilenameExtension(GeneratorEntry it) {
		headerFilenameExtensionParameter?.stringValue?:"h"
	}
	
	def getHeaderFilenameExtensionParameter(GeneratorEntry it) {
		identifierSettingsFeature?.getParameterValue(ICFeatureConstants::PARAMETER_HEADER_FILENAME_EXTENSION)
	}
	
	def getSourceFilenameExtension(GeneratorEntry it) {
		sourceFilenameExtensionParameter?.stringValue?:"c"
	}
	
	def getSourceFilenameExtensionParameter(GeneratorEntry it) {
		identifierSettingsFeature?.getParameterValue(ICFeatureConstants::PARAMETER_SOURCE_FILENAME_EXTENSION)
	}
	
	def private getTracingFeature(GeneratorEntry it) {
		getFeatureConfiguration(ICFeatureConstants::FEATURE_TRACING)
	}
	
	def getTracingEnterState(GeneratorEntry it){
		val enterStateParameter = tracingFeature?.getParameterValue(ICFeatureConstants::PARAMETER_TRACING_ENTER_STATE)
		if (enterStateParameter !== null) {
			return enterStateParameter.booleanValue
		}
		return false
	}
	
	def getTracingExitState(GeneratorEntry it){
		val exitStateParameter = tracingFeature?.getParameterValue(ICFeatureConstants::PARAMETER_TRACING_EXIT_STATE)
		if (exitStateParameter !== null) {
			return exitStateParameter.booleanValue
		}
		return false
	}
	
	def getTracingGeneric(GeneratorEntry it){
		val genericParameter = tracingFeature?.getParameterValue(ICFeatureConstants::PARAMETER_TRACING_GENERIC)
		if (genericParameter !== null) {
			return genericParameter.booleanValue
		}
		return false
	}
	
	def tracingUsed(GeneratorEntry it) {
		return (tracingEnterState || tracingExitState)
	}
	
	def private getGeneratorOptionsFeature(GeneratorEntry it) {
		getFeatureConfiguration(ICFeatureConstants::FEATURE_GENERATOR_OPTIONS)
	}
	
	def getQueueAllocatedByUser(GeneratorEntry it) {
		val parameter = generatorOptionsFeature?.getParameterValue(ICFeatureConstants::PARAMETER_USER_ALLOCATED_QUEUE)
		if(parameter !== null) {
			parameter.booleanValue
		} else {
			false
		}
	}
	
	def getMetaSource(GeneratorEntry it) {
		val parameter = generatorOptionsFeature?.getParameterValue(ICFeatureConstants::PARAMETER_META_SOURCE)
		if(parameter !== null) {
			parameter.booleanValue
		} else {
			false
		}
	}
	
	def private getGeneralFeaturesFeature(GeneratorEntry it) {
		getFeatureConfiguration(ICFeatureConstants::FEATURE_GENERAL_FEATURES)
	}
	
	def getTimerService(GeneratorEntry it) {
		val parameter = generalFeaturesFeature?.getParameterValue(ICFeatureConstants::TIMER_SERVICE)
		if (parameter !== null) {
			parameter.booleanValue
		} else {
			false
		}
	}
	
	def getTimerServiceTimeType(GeneratorEntry it) {
		val parameter = generalFeaturesFeature?.getParameterValue(ICFeatureConstants::TIMER_SERVICE_TIME_TYPE)
		if (parameter !== null && !parameter.stringValue.nullOrEmpty) {
			parameter.getStringValue
		} else {
			"int32_t"
		}
	}
	
	def private getIncludesFeature(GeneratorEntry it){
		getFeatureConfiguration(ICFeatureConstants::FEATURE_INCLUDES)		
	}
	
	def getGenerateAllIncludes(GeneratorEntry it) {
		val parameter = getIncludesFeature?.getParameterValue(ICFeatureConstants::PARAMETER_GENERATE_ALL_INCLUDES)
		if (parameter !== null) {
			parameter.booleanValue
		} else {
			false
		}
	}
}
