/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.ConstantInitializationResolver
import com.yakindu.sct.generator.c.FlowCode
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.ExpressionsChecker
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.stext.stext.EventDefinition
import java.util.List

/**
 * @author rbeckmann
 * @author axel terfloth
 */
@Singleton // Guice
class InternalFunctionsGenerator {
	@Inject protected extension Naming
	@Inject protected extension GenmodelEntries
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension INamingService
	@Inject protected extension FlowCode
	@Inject protected extension ConstantInitializationResolver
	@Inject protected extension StateVectorExtensions
	@Inject protected extension ExpressionsChecker
	@Inject protected extension Literals
	@Inject protected extension CTypes
	@Inject protected extension GeneratorPredicate
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension EventNaming
	
	@Inject protected extension	TraceCode 
	@Inject protected extension	EventCode 
	

	def observerCallbacksImplementations(ExecutionFlow it) '''
		«FOR e : shadowEvents»
			static void «e.observerCallbackFctID»(«scHandleDecl»«IF e.hasValue», «e.typeSpecifier.targetLanguageName» value«ENDIF»)
			{
				«e.traceCode( if (e.hasValue) "&value" else "sc_null" )»
				«interfaceIncomingEventRaiserBody(e as EventDefinition)»
			}
		«ENDFOR»
	'''

	def observerCallbacksPrototypes(ExecutionFlow it) '''
		«FOR e : shadowEvents»
			static void «e.observerCallbackFctID»(«scHandleDecl»«IF e.hasValue», «e.typeSpecifier.targetLanguageName» value«ENDIF»);
		«ENDFOR»
	'''

	
	def <T> NOOUT(T p) ''''''
	
	
	def defines(ExecutionFlow it) '''
		#ifndef SC_UNUSED
		#define SC_UNUSED(P) (void)(P)
		#endif
	'''

	
	
	def functionPrototypes(ExecutionFlow it) '''
		/* prototypes of all internal functions */
		«checkFunctions.toPrototypes»
		«effectFunctions.toPrototypes»
		«entryActionFunctions.toPrototypes»
		«exitActionFunctions.toPrototypes»
		«enterSequenceFunctions.toPrototypes»
		«exitSequenceFunctions.toPrototypes»
		«reactFunctions.filter[ f | ! (f.eContainer instanceof ExecutionState)].toList.toPrototypes»
	'''
	
	
	
	
	def toPrototypes(List<Step> steps) '''
		«FOR s : steps»
			«s.functionPrototype»
		«ENDFOR»
	'''
	
	def dispatch functionPrototype(Check it) '''
		static «sc_bool.name» «shortName»(«scHandleDecl»);
	'''
	
	def dispatch functionPrototype(Step it) '''
		static void «shortName»(«scHandleDecl»);
	'''	
	
	def functionImplementations(ExecutionFlow it) '''
		/* implementations of all internal functions */
		
		«checkFunctions.toImplementation»
		«effectFunctions.toImplementation»
		«entryActionFunctions.toImplementation»
		«exitActionFunctions.toImplementation»
		«enterSequenceFunctions.toImplementation»
		«exitSequenceFunctions.toImplementation»
		«reactFunctions.filter[ f | ! (f.eContainer instanceof ExecutionState)].toList.toImplementation»
	'''
	
	
	def toImplementation(List<Step> steps) '''
		«FOR s : steps»
			«s.functionImplementation»
		«ENDFOR»
	'''
	
	def dispatch functionImplementation(Check it) '''
		«stepComment»
		static «sc_bool.name» «shortName»(«scHandleDecl»)
		{
			return «code»;
		}
		
	'''
	
	def dispatch functionImplementation(Step it) '''
		«stepComment»
		static void «shortName»(«scHandleDecl»)
		{
			«IF !it.requiresHandles»
				«unusedParam(scHandle)»
			«ENDIF»
			«code»
		}
		
	'''
}
