/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.base.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.types.Expression
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.inferrer.TypesProvider
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.ExpressionStatement
import com.yakindu.sctunit.sCTUnit.IfStatement
import com.yakindu.sctunit.sCTUnit.LoopStatement
import com.yakindu.sctunit.sCTUnit.ProceedExpression
import com.yakindu.sctunit.sCTUnit.ReturnStatement
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

class BaseStatementExtensions {

	@Inject extension BaseExpressionExtensions
	@Inject protected TypesProvider provider
	@Inject extension ICodegenTypeSystemAccess
	
	def protected getTypeSystem(EObject context) {
		return provider.getTypeSystem(context);
	}

	def dispatch CharSequence generate(TestStatement statement) {
		'''Error'''
	}

	def dispatch CharSequence generate(LoopStatement stm) {
		'''	
			while («stm.guard.code») {
				«FOR statement : stm.body.code»
					«statement.generate»
				«ENDFOR»
			}
		'''
	}

	def dispatch CharSequence generate(ReturnStatement stm) {
		'''return «IF stm.returnValue !== null»«stm.returnValue.code»«ENDIF»;'''
	}

	def dispatch CharSequence generate(VariableDefinitionStatement stm) {
		if (stm.definition.initialValue !== null) {
			return stm.definition.generateInitialValue(stm.definition.initialValue)
		} else {
			'''«stm.definition.type.targetLanguageName» «stm.definition.name»;'''
		}
	}
	
	def dispatch CharSequence generate(IfStatement stm) {
		'''
			if («stm.condition.code») {
				«FOR trueExpression : stm.then.code»
					«stms.generate(trueExpression)»
				«ENDFOR»
			}
			«IF stm.^else !== null»
				else {
					«FOR falseExpression : stm.^else.code»
						«stms.generate(falseExpression)»
					«ENDFOR»
				}
			«ENDIF»
		'''
	}

	def dispatch CharSequence generate(ExpressionStatement stm) {
		val exp = stm.expression
		if ((stm.expression instanceof PrimitiveValueExpression) && stm.contextNotAssignOrVarDef) {
			return '''return «stm.expression.code»;'''
		} else if (exp instanceof ProceedExpression) {
			return '''«exp.code»'''
		} else if (EcoreUtil2.getContainerOfType(stm, typeof(AssertionStatement)) !== null) {
			return '''«exp.code»'''
		} else {
			return '''«exp.code»;'''
		}
	}

	def boolean contextNotAssignOrVarDef(ExpressionStatement stm) {
		return (EcoreUtil2.getContainerOfType(stm, typeof(AssignmentExpression)) === null) &&
			(EcoreUtil2.getContainerOfType(stm, typeof(VariableDefinition)) === null)
	}

	def CharSequence generateInitialValue(VariableDefinition it, Expression expr) {
		'''	
			«type.targetLanguageName» «name» = «expr.code»;
		'''
	}

}
