/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 */
package com.yakindu.sct.domain.java.generator

import com.yakindu.sct.generator.java.JavaExpressionsGenerator
import com.yakindu.base.expressions.expressions.IntLiteral
import com.google.inject.Inject
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.sct.domain.java.typesystem.JavaTypeSystem
import com.yakindu.base.types.Property
import static extension com.yakindu.sct.domain.java.resource.JavaFileLocationAdapter.*

/**
 * @author Axel Terfloth (terfloth@itemis.de)
 */
class JavaDomainExpressionGenerator extends JavaExpressionsGenerator{
	
	@Inject extension ITypeSystemInferrer
	@Inject extension JavaTypeSystem
	
	override dispatch CharSequence code(IntLiteral it) {
		if (JavaTypeSystem.INTEGER.type.isSame(it.infer.type))
			'''«value.toString»'''
		else
			'''«value.toString»l'''		
	}
	
	override dispatch String code(Property it) {
		
		if (it.hasJavaFileLocation) {
			context + name
		} else {
			super._code(it)
		} 
	}
	
	
}