/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.domain.java.generator

import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.sct.generator.java.types.JavaTypeSystemAccess

/** 
 * @author Rene Beckmann - Initial API and contribution
 */
class JavaDomainTypeSystemAccess extends JavaTypeSystemAccess {
	
	override String getTargetLanguageName(Type type) {
		if (type instanceof ComplexType) {
			// cut java.lang prefix
			if (type.name.startsWith("java.lang")) {
				return type.name.substring("java.lang".length + 1);
			}
			return type.name.replaceAll("\\$", ".")
		}
		var Type originType = type.getOriginType()
		if (originType !== null) {
			if (getType(type.name) !== null && (! getType(type.name).abstract)) {
				return type.name
			}
		}
		return super.getTargetLanguageName(type)
	}

	override String getTargetLanguageName(TypeSpecifier typeSpecifier) {
		if (typeSpecifier === null) {
			return ""
		}
		var String typeArguments = ""
		if (!typeSpecifier.getTypeArguments().isEmpty()) {
			var String collect = typeSpecifier.typeArguments.map[getTargetLanguageName].join(", ")
			typeArguments = '''<«collect»>'''.toString
		}
		return getTargetLanguageName(typeSpecifier.getType()) + typeArguments
	}
}
