/**
 * Copyright (c) 2020-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.simulation.core.sexec.interpreter

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.interpreter.types.TypesInterpreter
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sruntime.ExecutionEvent

/**
 * Interpreter implementation for execution flow models which provides the interpreter facade.
 *  
 * @author axel terfloth
 */
@Singleton
class SexecInterpreter extends TypesInterpreter {

	public static final String INIT = "init"
	public static final String ENTER = "enter"
	public static final String EXIT = "exit"
	public static final String RUN_CYCLE = "runCycle"
	public static final String TRIGGER_WITHOUT_EVENT = "triggerWithoutEvent"
	public static final String IS_ACTIVE = "isActive"
	public static final String IS_STATE_ACTIVE = "isStateActive"
	public static final String IS_FINAL = "isFinal"


	@Inject new(SexecExecution exec) {
		this.execution = exec
		this.execution.executionContext = this
		cleanupMemory
	}


	override protected void executeRaise(ExecutionEvent e, Object value) {
		
		if (e.name === TRIGGER_WITHOUT_EVENT) {
			e.instance.provideExecution(e)
		} else {
			e.raise(value)
		}
	}


	def dispatch CharSequence description(Method it) {
		'''«eContainer.description».«name»'''
	}

}
