/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private static final IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList<ILabelProviderListener> fListeners;
    private Map<MarkersCacheKey, IMarker[]> fMarkersCache = new HashMap<MarkersCacheKey, IMarker[]>();

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : CUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        int adornmentFlags = this.computeAdornmentFlags(obj);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new CElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object obj) {
        block11: {
            try {
                if (obj instanceof ICElement) {
                    ICElement element = (ICElement)obj;
                    int type = element.getElementType();
                    switch (type) {
                        case 11: 
                        case 12: {
                            return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                        }
                        case 60: {
                            return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                        }
                        case 65: 
                        case 67: 
                        case 69: 
                        case 70: 
                        case 74: 
                        case 76: {
                            ITranslationUnit tu = ((ISourceReference)element).getTranslationUnit();
                            if (tu != null && tu.exists()) {
                                return this.getErrorTicksFromMarkers(tu.getResource(), 1, (ISourceReference)element);
                            }
                            break block11;
                        }
                    }
                    break block11;
                }
                if (obj instanceof IResource) {
                    return this.getErrorTicksFromMarkers((IResource)obj, 2, null);
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 376) {
                    return 0;
                }
                CUIPlugin.log(e);
            }
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int info = 0;
        MarkersCacheKey cacheKey = new MarkersCacheKey(res, depth);
        IMarker[] markers = this.fMarkersCache.get(cacheKey);
        if (markers == null) {
            markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
            if (markers == null) {
                markers = EMPTY_MARKER_ARRAY;
            }
            this.fMarkersCache.put(cacheKey, markers);
        }
        int i = 0;
        while (i < markers.length && info != 64) {
            IMarker curr = markers[i];
            if (sourceElement == null || this.isMarkerInRange(curr, sourceElement)) {
                int priority = curr.getAttribute("severity", -1);
                if (priority == 1) {
                    info = 32;
                } else if (priority == 2) {
                    info = 64;
                }
            }
            ++i;
        }
        return info;
    }

    private boolean isMarkerInRange(IMarker marker, ISourceReference sourceElement) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int line;
            int pos = marker.getAttribute("charStart", -1);
            if (pos == -1 && (line = MarkerUtilities.getLineNumber((IMarker)marker)) >= 0) {
                return this.isInside(-1, line, sourceElement);
            }
            return this.isInside(pos, -1, sourceElement);
        }
        return false;
    }

    protected boolean isInside(int offSet, int line, ISourceReference sourceElement) throws CoreException {
        ISourceRange range = sourceElement.getSourceRange();
        if (range != null) {
            if (offSet == -1) {
                return line >= range.getStartLine() && line <= range.getEndLine();
            }
            int rangeOffset = range.getStartPos();
            return rangeOffset <= offSet && rangeOffset + range.getLength() > offSet;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = (changedResources, isMarkerChange) -> this.fireProblemsChanged(changedResources, isMarkerChange);
            CUIPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    protected void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        this.fMarkersCache.clear();
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            for (ILabelProviderListener listener : this.fListeners) {
                listener.labelProviderChanged((LabelProviderChangedEvent)event);
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags == 64) {
            decoration.addOverlay(CPluginImages.DESC_OVR_ERROR);
        } else if (adornmentFlags == 32) {
            decoration.addOverlay(CPluginImages.DESC_OVR_WARNING);
        }
    }

    private static class MarkersCacheKey {
        private IResource res;
        private int depth;

        public MarkersCacheKey(IResource res, int depth) {
            this.res = res;
            this.depth = depth;
        }

        public int hashCode() {
            return this.res.hashCode() + 31 * this.depth;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MarkersCacheKey other = (MarkersCacheKey)obj;
            return this.depth == other.depth && this.res.equals((Object)other.res);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider source, IResource[] changedResource, boolean isMarkerChange) {
            super(source, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

