/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.AssignmentOperator;
import com.yakindu.base.expressions.expressions.BitwiseAndExpression;
import com.yakindu.base.expressions.expressions.BitwiseOrExpression;
import com.yakindu.base.expressions.expressions.BitwiseXorExpression;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.ConditionalExpression;
import com.yakindu.base.expressions.expressions.DoubleLiteral;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.FloatLiteral;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.LogicalAndExpression;
import com.yakindu.base.expressions.expressions.LogicalNotExpression;
import com.yakindu.base.expressions.expressions.LogicalOrExpression;
import com.yakindu.base.expressions.expressions.LogicalRelationExpression;
import com.yakindu.base.expressions.expressions.NullLiteral;
import com.yakindu.base.expressions.expressions.NumericalAddSubtractExpression;
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression;
import com.yakindu.base.expressions.expressions.NumericalUnaryExpression;
import com.yakindu.base.expressions.expressions.ParenthesizedExpression;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.ShiftExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.expressions.expressions.TypeCastExpression;
import com.yakindu.base.expressions.interpreter.AbstractExpressionInterpreter;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.base.expressions.interpreter.IOperationExecutor;
import com.yakindu.base.expressions.interpreter.SlotResolutionExceptionSupplier;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.SRuntimeFunction;
import com.yakindu.base.expressions.interpreter.base.ValueSemantics;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class DefaultExpressionInterpreter
extends AbstractExpressionInterpreter
implements IExpressionInterpreter {
    @Inject
    @Extension
    protected ITypeSystem ts;
    @Inject
    @Extension
    protected IExecutionSlotResolver resolver;
    @Inject
    @Extension
    protected ValueSemantics valueSemantics;
    @Inject
    @Extension
    protected SRuntimeFunction _sRuntimeFunction;
    @Inject(optional=true)
    protected Set<IOperationExecutor> operationExecutors = Sets.newHashSet();
    @Inject(optional=true)
    protected ExecutionContext context;
    @Inject
    @Extension
    protected ExpressionExtensions _expressionExtensions;

    @Override
    public Object evaluate(Expression statement, ExecutionContext context) {
        Object _xblockexpression = null;
        this.context = context;
        _xblockexpression = this.execute(statement);
        return _xblockexpression;
    }

    protected Object _execute(Expression statement) {
        return null;
    }

    protected Object _execute(ConditionalExpression expression) {
        Object _value = this.value(expression.getCondition());
        if (((Boolean)_value).booleanValue()) {
            return this.value(expression.getTrueCase());
        }
        return this.value(expression.getFalseCase());
    }

    protected Object value(Expression expression) {
        return this.valueSemantics.asValue(this.execute(expression));
    }

    protected Object _execute(BitwiseAndExpression expression) {
        return this.executeBinaryCoreFunction(expression.getLeftOperand(), expression.getRightOperand(), "&");
    }

    protected Object _execute(BitwiseOrExpression expression) {
        return this.executeBinaryCoreFunction(expression.getLeftOperand(), expression.getRightOperand(), "|");
    }

    protected Object _execute(BitwiseXorExpression expression) {
        return this.executeBinaryCoreFunction(expression.getLeftOperand(), expression.getRightOperand(), "^");
    }

    protected Object _execute(LogicalRelationExpression expression) {
        return this.executeBinaryCoreFunction(expression.getLeftOperand(), expression.getRightOperand(), expression.getOperator().getName());
    }

    protected Object _execute(NumericalAddSubtractExpression expression) {
        return this.executeBinaryCoreFunction(expression.getLeftOperand(), expression.getRightOperand(), expression.getOperator().getLiteral());
    }

    protected Object _execute(NumericalMultiplyDivideExpression expression) {
        return this.executeBinaryCoreFunction(expression.getLeftOperand(), expression.getRightOperand(), expression.getOperator().getName());
    }

    protected Object _execute(ShiftExpression expression) {
        return this.executeBinaryCoreFunction(expression.getLeftOperand(), expression.getRightOperand(), expression.getOperator().getName());
    }

    protected Object _execute(NumericalUnaryExpression expression) {
        return this.executeUnaryCoreFunction(expression.getOperand(), expression.getOperator().getName());
    }

    protected Object _execute(PostFixUnaryExpression it) {
        try {
            Object _xblockexpression = null;
            Object result = this.value(it.getOperand());
            ExecutionSlot slot = this.resolveSlot(this.context, it.getOperand()).orElseThrow(SlotResolutionExceptionSupplier.forContext(it.getOperand()));
            slot.setValue(this._sRuntimeFunction.evaluate(it.getOperator().getName(), result));
            _xblockexpression = result;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Object executeBinaryCoreFunction(Expression leftStatement, Expression rightStatement, String operator) {
        Object leftResult = this.value(leftStatement);
        Object rightResult = this.value(rightStatement);
        return this._sRuntimeFunction.evaluate(operator, leftResult, rightResult);
    }

    protected Object _execute(LogicalAndExpression expression) {
        Object leftResult = this.value(expression.getLeftOperand());
        if (!((Boolean)leftResult).booleanValue()) {
            return false;
        }
        Object rightResult = this.value(expression.getRightOperand());
        return (Boolean)leftResult != false && (Boolean)rightResult != false;
    }

    protected Object _execute(LogicalOrExpression expression) {
        Object leftResult = this.value(expression.getLeftOperand());
        if (((Boolean)leftResult).booleanValue()) {
            return true;
        }
        Object rightResult = this.value(expression.getRightOperand());
        return (Boolean)leftResult != false || (Boolean)rightResult != false;
    }

    protected Object _execute(LogicalNotExpression expression) {
        Object _value = this.value(expression.getOperand());
        return (Boolean)_value == false;
    }

    protected Object resolveReference(Object element) {
        if (element instanceof ReferenceSlot) {
            return ((ReferenceSlot)element).getReference();
        }
        return element;
    }

    protected Object _execute(AssignmentExpression assignment) {
        return this.executeAssignment(assignment);
    }

    protected Object _execute(TypeCastExpression expression) {
        Object _xblockexpression = null;
        Object operand = this.value(expression.getOperand());
        _xblockexpression = this.typeCast(operand, expression.getType().getOriginType());
        return _xblockexpression;
    }

    public Object cast(Object value, Type type) {
        Object _xifexpression = null;
        _xifexpression = type != null ? this.typeCast(value, type.getOriginType()) : value;
        return _xifexpression;
    }

    protected Object _typeCast(Long value, Type type) {
        if (type instanceof EnumerationType) {
            return ((EnumerationType)type).getEnumerator().get(value.intValue());
        }
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("integer"));
        if (_isSuperType) {
            return value;
        }
        boolean _isSuperType_1 = this.ts.isSuperType(type, this.ts.getType("real"));
        if (_isSuperType_1) {
            return (double)value.longValue();
        }
        String _name = type.getName();
        String _plus = "unknown type " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected Object _typeCast(Float value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("integer"));
        if (_isSuperType) {
            return value.longValue();
        }
        boolean _isSuperType_1 = this.ts.isSuperType(type, this.ts.getType("real"));
        if (_isSuperType_1) {
            return (double)value.floatValue();
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Float to " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected Object _typeCast(Double value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("integer"));
        if (_isSuperType) {
            return value.longValue();
        }
        boolean _isSuperType_1 = this.ts.isSuperType(type, this.ts.getType("real"));
        if (_isSuperType_1) {
            return (double)value;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Double to " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected Object _typeCast(Boolean value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("boolean"));
        if (_isSuperType) {
            return value;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Boolean to " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected Object _typeCast(String value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("string"));
        if (_isSuperType) {
            return value;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from String to " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected Object _typeCast(Enumerator value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, (Type)value.getOwningEnumeration());
        if (_isSuperType) {
            return value;
        }
        boolean _isSuperType_1 = this.ts.isSuperType(type, this.ts.getType("integer"));
        if (_isSuperType_1) {
            int _literalValue = value.getLiteralValue();
            return (long)_literalValue;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Enumerator to " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected Object _typeCast(Object value, Type type) {
        return value;
    }

    public Object executeAssignment(AssignmentExpression assignment) {
        try {
            Object _xblockexpression = null;
            ExecutionSlot scopeVariable = this.resolveSlot(this.context, assignment.getVarRef()).orElseThrow(SlotResolutionExceptionSupplier.forContext(assignment.getVarRef()));
            Object result = this.value(assignment.getExpression());
            if (scopeVariable instanceof CompositeSlot) {
                return this.executeComplexAssignment((CompositeSlot)scopeVariable, result);
            }
            AssignmentOperator _operator = assignment.getOperator();
            boolean _equals = Objects.equals(_operator, AssignmentOperator.ASSIGN);
            if (_equals) {
                Object _xifexpression = null;
                _xifexpression = result != null ? this.cast(result, scopeVariable.getType()) : null;
                scopeVariable.setValue(_xifexpression);
            } else {
                String operator = AbstractExpressionInterpreter.assignFunctionMap.get(assignment.getOperator().getName());
                Object _xifexpression_1 = null;
                _xifexpression_1 = result != null ? this.cast(this._sRuntimeFunction.evaluate(operator, scopeVariable.getValue(), result), scopeVariable.getType()) : null;
                scopeVariable.setValue(_xifexpression_1);
            }
            _xblockexpression = scopeVariable.getValue();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Object executeComplexAssignment(CompositeSlot slot, Object result) {
        Object _xblockexpression = null;
        this.valueSemantics.setValue(slot, result);
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected Object _execute(ParenthesizedExpression e) {
        return this.execute(e.getExpression());
    }

    protected Object _execute(PrimitiveValueExpression expression) {
        return this.valueLiteral(expression.getValue());
    }

    protected Object _valueLiteral(IntLiteral literal) {
        long _value = literal.getValue();
        return _value;
    }

    protected Object _valueLiteral(BoolLiteral bool) {
        return bool.isValue();
    }

    protected Object _valueLiteral(DoubleLiteral literal) {
        return literal.getValue();
    }

    protected Object _valueLiteral(FloatLiteral literal) {
        return Float.valueOf(literal.getValue());
    }

    protected Object _valueLiteral(StringLiteral literal) {
        return literal.getValue();
    }

    protected Object _valueLiteral(NullLiteral literal) {
        return IInterpreter.NULL;
    }

    protected Object _execute(ElementReferenceExpression expression) {
        return this.executeElementReferenceExpression(expression);
    }

    public Object executeElementReferenceExpression(ElementReferenceExpression expression) {
        Optional<ExecutionSlot> slot = this.resolveSlot(this.context, (Expression)expression);
        return this.doExecute(expression.getReference(), slot.orElse(null), (ArgumentExpression)expression);
    }

    protected Object _execute(EventValueReferenceExpression expression) {
        try {
            List _raisedEvents = this.context.getRaisedEvents();
            for (ExecutionEvent event : _raisedEvents) {
                ExecutionSlot slot = this.resolver.resolve(this.context, expression.getValue()).orElseThrow(SlotResolutionExceptionSupplier.forContext(expression.getValue()));
                if (!(slot instanceof ExecutionEvent) || !Objects.equals(slot.getFqName(), event.getFqName())) continue;
                return event.getValue();
            }
            String _eventName = this.getEventName(expression.getValue());
            String _plus = "Undefined value of event '" + _eventName;
            String _plus_1 = _plus + "'\n";
            String _plus_2 = _plus_1 + "Event values only exist in the same cycle in which the event was raised.";
            throw new UndefinedValueException(_plus_2);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String _getEventName(ElementReferenceExpression it) {
        EObject _reference = it.getReference();
        if (_reference instanceof Event) {
            EObject _reference_1 = it.getReference();
            return ((Event)_reference_1).getName();
        }
        return "null";
    }

    protected String _getEventName(Expression it) {
        return "null";
    }

    protected String _getEventName(FeatureCall it) {
        EObject _feature = it.getFeature();
        if (_feature instanceof Event) {
            EObject _feature_1 = it.getFeature();
            return ((Event)_feature_1).getName();
        }
        return "null";
    }

    protected Object _execute(FeatureCall call) {
        return this.executeFeatureCall(call);
    }

    public Object executeFeatureCall(FeatureCall call) {
        Object result = null;
        List _callStack = this._expressionExtensions.toCallStack((Expression)call);
        for (ArgumentExpression exp : _callStack) {
            Optional<ExecutionSlot> slot = this.resolveSlot(this.context, (Expression)exp);
            result = this.doExecute(this._expressionExtensions.featureOrReference((Expression)exp), slot.orElse(null), exp);
        }
        return result;
    }

    protected Object _doExecute(EObject feature, Void slot, ArgumentExpression exp) {
        Object _xblockexpression = null;
        InputOutput.println((Object)("No implementation found for " + String.valueOf(exp) + " -> returning null"));
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected Object _doExecute(EObject feature, ExecutionVariable slot, ArgumentExpression exp) {
        return slot.getValue();
    }

    protected Object _doExecute(EObject feature, CompositeSlot slot, ArgumentExpression exp) {
        return slot;
    }

    protected Object _doExecute(EObject feature, ExecutionEvent slot, ArgumentExpression exp) {
        return slot.isRaised();
    }

    protected Object _doExecute(Operation feature, ExecutionEvent slot, ArgumentExpression exp) {
        slot.setRaised(true);
        return null;
    }

    protected Object _doExecute(Operation feature, Void slot, ArgumentExpression exp) {
        Functions.Function1 _function = it -> it.canExecute(exp, this.context);
        IOperationExecutor executor = (IOperationExecutor)IterableExtensions.findFirst(this.operationExecutors, (Functions.Function1)_function);
        if (executor != null) {
            return this.executeOperation(executor, exp);
        }
        return null;
    }

    protected Object _doExecute(Operation feature, ExecutionSlot slot, ArgumentExpression exp) {
        Functions.Function1 _function = it -> it.canExecute(exp, this.context);
        IOperationExecutor executor = (IOperationExecutor)IterableExtensions.findFirst(this.operationExecutors, (Functions.Function1)_function);
        if (executor != null) {
            slot.setValue(this.executeOperation(executor, exp));
        }
        return slot.getValue();
    }

    protected Object _doExecute(Operation feature, CompositeSlot slot, ArgumentExpression exp) {
        Functions.Function1 _function = it -> it.canExecute(exp, this.context);
        IOperationExecutor executor = (IOperationExecutor)IterableExtensions.findFirst(this.operationExecutors, (Functions.Function1)_function);
        if (executor != null) {
            return this.executeOperation(executor, exp);
        }
        return slot;
    }

    protected Object _doExecute(Enumerator feature, Void slot, ArgumentExpression exp) {
        return feature;
    }

    protected Object _doExecute(Type feature, Void slot, ArgumentExpression exp) {
        return null;
    }

    public Object executeUnaryCoreFunction(Expression statement, String operator) {
        Object result = this.value(statement);
        return this._sRuntimeFunction.evaluate(operator, result);
    }

    public Object executeOperation(IOperationExecutor executor, ArgumentExpression expression) {
        return executor.execute(expression, this.context);
    }

    protected Optional<ExecutionSlot> resolveSlot(ExecutionContext context, Expression expression) {
        return this.resolver.resolve(context, expression);
    }

    @XbaseGenerated
    public Object execute(Expression expression) {
        if (expression instanceof BitwiseAndExpression) {
            return this._execute((BitwiseAndExpression)expression);
        }
        if (expression instanceof BitwiseOrExpression) {
            return this._execute((BitwiseOrExpression)expression);
        }
        if (expression instanceof BitwiseXorExpression) {
            return this._execute((BitwiseXorExpression)expression);
        }
        if (expression instanceof ElementReferenceExpression) {
            return this._execute((ElementReferenceExpression)expression);
        }
        if (expression instanceof FeatureCall) {
            return this._execute((FeatureCall)expression);
        }
        if (expression instanceof LogicalAndExpression) {
            return this._execute((LogicalAndExpression)expression);
        }
        if (expression instanceof LogicalNotExpression) {
            return this._execute((LogicalNotExpression)expression);
        }
        if (expression instanceof LogicalOrExpression) {
            return this._execute((LogicalOrExpression)expression);
        }
        if (expression instanceof LogicalRelationExpression) {
            return this._execute((LogicalRelationExpression)expression);
        }
        if (expression instanceof NumericalAddSubtractExpression) {
            return this._execute((NumericalAddSubtractExpression)expression);
        }
        if (expression instanceof NumericalMultiplyDivideExpression) {
            return this._execute((NumericalMultiplyDivideExpression)expression);
        }
        if (expression instanceof NumericalUnaryExpression) {
            return this._execute((NumericalUnaryExpression)expression);
        }
        if (expression instanceof PostFixUnaryExpression) {
            return this._execute((PostFixUnaryExpression)expression);
        }
        if (expression instanceof ShiftExpression) {
            return this._execute((ShiftExpression)expression);
        }
        if (expression instanceof AssignmentExpression) {
            return this._execute((AssignmentExpression)expression);
        }
        if (expression instanceof ConditionalExpression) {
            return this._execute((ConditionalExpression)expression);
        }
        if (expression instanceof EventValueReferenceExpression) {
            return this._execute((EventValueReferenceExpression)expression);
        }
        if (expression instanceof ParenthesizedExpression) {
            return this._execute((ParenthesizedExpression)expression);
        }
        if (expression instanceof PrimitiveValueExpression) {
            return this._execute((PrimitiveValueExpression)expression);
        }
        if (expression instanceof TypeCastExpression) {
            return this._execute((TypeCastExpression)expression);
        }
        if (expression != null) {
            return this._execute(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }

    @XbaseGenerated
    protected Object typeCast(Object value, Type type) {
        if (value instanceof Enumerator) {
            return this._typeCast((Enumerator)value, type);
        }
        if (value instanceof Double) {
            return this._typeCast((Double)value, type);
        }
        if (value instanceof Float) {
            return this._typeCast((Float)value, type);
        }
        if (value instanceof Long) {
            return this._typeCast((Long)value, type);
        }
        if (value instanceof Boolean) {
            return this._typeCast((Boolean)value, type);
        }
        if (value instanceof String) {
            return this._typeCast((String)value, type);
        }
        if (value != null) {
            return this._typeCast(value, type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value, type).toString());
    }

    @XbaseGenerated
    public Object valueLiteral(Literal bool) {
        if (bool instanceof BoolLiteral) {
            return this._valueLiteral((BoolLiteral)bool);
        }
        if (bool instanceof DoubleLiteral) {
            return this._valueLiteral((DoubleLiteral)bool);
        }
        if (bool instanceof FloatLiteral) {
            return this._valueLiteral((FloatLiteral)bool);
        }
        if (bool instanceof IntLiteral) {
            return this._valueLiteral((IntLiteral)bool);
        }
        if (bool instanceof NullLiteral) {
            return this._valueLiteral((NullLiteral)bool);
        }
        if (bool instanceof StringLiteral) {
            return this._valueLiteral((StringLiteral)bool);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(bool).toString());
    }

    @XbaseGenerated
    protected String getEventName(Expression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._getEventName((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._getEventName((FeatureCall)it);
        }
        if (it != null) {
            return this._getEventName(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public Object doExecute(EObject feature, ExecutionSlot slot, ArgumentExpression exp) {
        if (feature instanceof Operation && slot instanceof CompositeSlot) {
            return this._doExecute((Operation)feature, (CompositeSlot)slot, exp);
        }
        if (feature instanceof Operation && slot instanceof ExecutionEvent) {
            return this._doExecute((Operation)feature, (ExecutionEvent)slot, exp);
        }
        if (feature instanceof Operation && slot != null) {
            return this._doExecute((Operation)feature, slot, exp);
        }
        if (feature instanceof Enumerator && slot == null) {
            return this._doExecute((Enumerator)feature, null, exp);
        }
        if (feature instanceof Operation && slot == null) {
            return this._doExecute((Operation)feature, (Void)null, exp);
        }
        if (feature instanceof Type && slot == null) {
            return this._doExecute((Type)feature, null, exp);
        }
        if (feature != null && slot instanceof CompositeSlot) {
            return this._doExecute(feature, (CompositeSlot)slot, exp);
        }
        if (feature != null && slot instanceof ExecutionEvent) {
            return this._doExecute(feature, (ExecutionEvent)slot, exp);
        }
        if (feature != null && slot instanceof ExecutionVariable) {
            return this._doExecute(feature, (ExecutionVariable)slot, exp);
        }
        if (feature != null && slot == null) {
            return this._doExecute(feature, (Void)null, exp);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(feature, slot, exp).toString());
    }

    protected static class UndefinedValueException
    extends IllegalStateException {
        public UndefinedValueException(String message) {
            super(message);
        }
    }
}

