/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.submodules;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class TypeCode {
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;

    protected CharSequence _toCode(ComplexType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class ");
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName((Type)it);
        _builder.append(_targetLanguageName);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"\"\"Implementation of internal scope.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self");
        Iterable _filter = Iterables.filter((Iterable)it.getFeatures(), Property.class);
        for (Property prop : _filter) {
            _builder.append(", ");
            String _identifier = this._naming.identifier((EObject)prop);
            _builder.append(_identifier, "\t");
        }
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Functions.Function1 _function = it_1 -> this.toCode((Declaration)it_1);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)it.getFeatures(), (Functions.Function1)_function));
        _builder.append(_join, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _toCode(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("self.");
        String _identifier = this._naming.identifier((EObject)event);
        _builder.append(_identifier);
        _builder.append(" = False");
        _builder.newLineIfNotEmpty();
        boolean _hasValue = this._sExecExtensions.hasValue((Object)event);
        if (_hasValue) {
            _builder.append("self.");
            String _valueIdentifier = this._naming.getValueIdentifier((EObject)event);
            _builder.append(_valueIdentifier);
            _builder.append(" = None");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _toCode(Property prop) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("self.");
        String _identifier = this._naming.identifier((EObject)prop);
        _builder.append(_identifier);
        _builder.append(" = ");
        String _identifier_1 = this._naming.identifier((EObject)prop);
        _builder.append(_identifier_1);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @XbaseGenerated
    public CharSequence toCode(Declaration it) {
        if (it instanceof ComplexType) {
            return this._toCode((ComplexType)it);
        }
        if (it instanceof Event) {
            return this._toCode((Event)it);
        }
        if (it instanceof Property) {
            return this._toCode((Property)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

