/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.utils;

import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.IEclipseLicenseService;
import com.yakindu.licmgmt.ILicenseEventListener;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.internal.EclipseLicenseService;
import com.yakindu.licmgmt.internal.IEclipseLicenseSettings;
import com.yakindu.licmgmt.internal.events.LicenseErrorEvent;
import com.yakindu.licmgmt.internal.events.LicenseWarningEvent;
import com.yakindu.licmgmt.internal.preferences.LicensePreferences;
import com.yakindu.licmgmt.ui.IEclipseLicenseUIService;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import com.yakindu.licmgmt.ui.notification.dialog.LicenseErrorDialog;
import com.yakindu.licmgmt.ui.notification.popup.NotificationService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LicenseNotifications
implements ILicenseEventListener {
    private static final String ACTION_SHOW_LICENSES = "Show licenses";
    private static final String ACTION_SOLUTION = "What can I do?";
    private static final String ACTION_DONT_SHOW_AGAIN = "Don't show again";
    private LicenseErrorDialog dialog = null;

    public void event(ILicenseEventListener.ILicenseEvent event) {
        if (event instanceof LicenseErrorEvent) {
            this.showDialog((LicenseErrorEvent)event);
        } else if (event instanceof LicenseWarningEvent) {
            this.showNotification((LicenseWarningEvent)event);
        }
    }

    private void showDialog(LicenseErrorEvent event) {
        String featureId = event.getFeatureId();
        String featureAndProductName = EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(featureId);
        IEclipseLicenseManager licenseManager = EclipseLicenseHelper.INSTANCE.getLoadedLicenseManager(featureId);
        if (this.getSettings().isLicenseNotificationEnabled(featureId) && !this.getSettings().isLicenseNotificationDialogSuppressed()) {
            String reason = licenseManager.getStatusMessage();
            this.openOrExtendLicenseErrorDialog((ILicenseManager)licenseManager, featureAndProductName, reason);
        } else {
            this.showNotification("License " + featureAndProductName, event.getText(), 4, featureId, (ILicenseManager)licenseManager);
        }
    }

    private void showNotification(LicenseWarningEvent event) {
        String featureId = event.getFeatureId();
        if (featureId != null && this.getSettings().isLicenseNotificationEnabled(featureId)) {
            this.showNotification(event.getTitle(), event.getText(), 2, featureId, null);
        }
    }

    private void showNotification(String rawTitle, String rawText, int severity, String featureId, ILicenseManager licenseManager) {
        String title = rawTitle;
        String text = rawText;
        if (featureId != null && (title.contains(featureId) || text.contains(featureId))) {
            String featureName = EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(featureId);
            if (title.contains(featureId)) {
                title = title.replaceFirst("'?" + Pattern.quote(featureId) + "'?", featureName);
            }
            if (text.contains(featureId)) {
                text = text.replaceFirst("'?" + Pattern.quote(featureId) + "'?", featureName);
            }
        }
        boolean dontShowAgainButton = severity == 2;
        Map<String, Runnable> actions = this.getActions(featureId, dontShowAgainButton, licenseManager);
        NotificationService.getInstance().addNotification(title, text, actions, severity);
    }

    private void openOrExtendLicenseErrorDialog(ILicenseManager licenseManager, String productName, String reason) {
        Display.getDefault().asyncExec(() -> {
            Shell shell = this.getShell();
            boolean dialogCreated = false;
            Class<LicenseNotifications> clazz = LicenseNotifications.class;
            synchronized (LicenseNotifications.class) {
                if (this.dialog == null) {
                    this.dialog = new LicenseErrorDialog(shell, newDialog -> {
                        Class<LicenseNotifications> clazz = LicenseNotifications.class;
                        synchronized (LicenseNotifications.class) {
                            this.dialog = newDialog.orElse(null);
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }, () -> PreferencesUtil.createPreferenceDialogOn(null, (String)"com.yakindu.licmgmt.ui.preferences.page", null, null).open());
                    dialogCreated = true;
                }
                this.dialog.add(() -> IEclipseLicenseUIService.INSTANCE.openHandleInvalidLicenseDialog(licenseManager), productName, reason);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                if (dialogCreated) {
                    this.dialog.open();
                }
                return;
            }
        });
    }

    private Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return this.getPreferenceOrWorkbenchShell(activeWorkbenchWindow);
        }
        if (workbench.getWorkbenchWindows().length > 0) {
            return this.getPreferenceOrWorkbenchShell(workbench.getWorkbenchWindows()[0]);
        }
        return null;
    }

    private Shell getPreferenceOrWorkbenchShell(IWorkbenchWindow workbenchWindow) {
        Shell[] shellArray = workbenchWindow.getShell().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell subShell = shellArray[n2];
            if ("Preferences".equals(subShell.getText())) {
                return subShell;
            }
            ++n2;
        }
        return workbenchWindow.getShell();
    }

    private Map<String, Runnable> getActions(String featureId, boolean dontShowAgainButton, ILicenseManager licenseManager) {
        LinkedHashMap<String, Runnable> actions = new LinkedHashMap<String, Runnable>();
        if (licenseManager != null && this.isLicenseError(licenseManager)) {
            actions.put(ACTION_SOLUTION, () -> IEclipseLicenseUIService.INSTANCE.openHandleInvalidLicenseDialog(licenseManager));
        }
        actions.put(ACTION_SHOW_LICENSES, () -> {
            int n = PreferencesUtil.createPreferenceDialogOn(null, (String)"com.yakindu.licmgmt.ui.preferences.page", null, null).open();
        });
        if (featureId != null && dontShowAgainButton && LicensePreferences.isLicenseNotification((String)featureId)) {
            actions.put(ACTION_DONT_SHOW_AGAIN, () -> LicensePreferences.setLicenseNotification((String)featureId, (boolean)false));
        }
        return actions;
    }

    private boolean isLicenseError(ILicenseManager licenseManager) {
        LmxStatus lmxStatus = EclipseLicenseHelper.INSTANCE.getLicenseManager(licenseManager).getLmxStatus();
        return lmxStatus != null && lmxStatus != LmxStatus.LMX_SUCCESS;
    }

    private IEclipseLicenseSettings getSettings() {
        return ((EclipseLicenseService)IEclipseLicenseService.INSTANCE).getSettings();
    }
}

