/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.subscriber;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.subscriber.SubscriberProviderDescriptor;
import org.eclipse.emf.compare.ide.ui.subscriber.ISubscriberProvider;
import org.eclipse.team.core.subscribers.Subscriber;

public class SubscriberProviderRegistry {
    private final Map<String, SubscriberProviderDescriptor> registeredDescriptors = new LinkedHashMap<String, SubscriberProviderDescriptor>();

    public void addProvider(String className, SubscriberProviderDescriptor descriptor) {
        this.registeredDescriptors.put(className, descriptor);
    }

    public SubscriberProviderDescriptor removeProvider(String className) {
        return this.registeredDescriptors.remove(className);
    }

    public void clear() {
        this.registeredDescriptors.clear();
    }

    public Subscriber getSubscriber(ICompareContainer container, ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        List rankedDescriptors = this.registeredDescriptors.values().stream().sorted(Comparator.comparingInt(SubscriberProviderDescriptor::getRanking).reversed()).collect(Collectors.toList());
        for (SubscriberProviderDescriptor descriptor : rankedDescriptors) {
            Subscriber subscriber;
            ISubscriberProvider provider = descriptor.getSubscriberProvider();
            if (provider == null || (subscriber = provider.getSubscriber(container, left, right, origin, monitor)) == null) continue;
            return subscriber;
        }
        return null;
    }
}

